<?php
require_once __DIR__.'/../lib/bootstrap.php';
require_once __DIR__.'/../lib/config.php';
require_once __DIR__.'/../lib/payments.php';
require_once __DIR__.'/../lib/telegram.php';

$pid = (int)($_GET['pid'] ?? 0);
$authority = $_GET['Authority'] ?? '';

if (!$pid || !$authority) { echo "bad parameters"; exit; }

$stmt = $pdo->prepare("SELECT * FROM payments WHERE id=:id AND authority=:a LIMIT 1");
$stmt->execute([':id'=>$pid, ':a'=>$authority]);
$pay = $stmt->fetch();
if (!$pay || $pay['status'] !== 'pending') { echo "invalid/processed"; exit; }

$amount_rial = (int)$pay['amount_rial'];
$verify = zarin_verify($authority, $amount_rial);

if ($verify['ok']) {
  $pdo->beginTransaction();
  $stmt = $pdo->prepare("UPDATE payments SET status='paid', ref_id=:r WHERE id=:id AND status='pending'");
  $stmt->execute([':r'=>$verify['ref_id'], ':id'=>$pid]);
  $pdo->commit();

  // TODO: رزرو/اختصاص شماره واقعی از پنل و ارسال به کاربر
  // فعلاً فقط پیام موفقیت برای ادمین:
  if (BOT_ADMIN_CHAT) {
    tg_sendMessage(BOT_ADMIN_CHAT, "✅ پرداخت موفق pid={$pid} ref={$verify['ref_id']}");
  }
  echo "پرداخت موفق ✔️";
} else {
  $pdo->prepare("UPDATE payments SET status='failed' WHERE id=:id")->execute([':id'=>$pid]);
  echo "پرداخت ناموفق ✖️";
}
