<?php
/**
 * Iran Stars — Telegram Bot (Patch v1)
 * - Panel1 (web token) + Panel2 (bearer; none_report)
 * - Profit shown in list + purchase
 * - No wallet deduction until code received
 * - Card-to-card flow + admin review
 * - Payment toggles (settings table)
 * - User tracking (last_seen)
 * - Stars/Premium quick link
 */

ob_start();
error_reporting(0);
require_once __DIR__ . '/class.php';
date_default_timezone_set('Asia/Tehran');

define('CALINOO_WEB_BASE', 'https://api.ozvinoo.xyz/web');
define('CALINOO_V2_BASE',  'https://api.ozvinoo.xyz');
define('PAGE_SIZE', 10);
define('CACHE_DIR', __DIR__ . '/.cache');
if (!is_dir(CACHE_DIR)) { @mkdir(CACHE_DIR, 0775, true); }

$calinooBearerToken = $apicalino; // re-use as bearer

function cache_set($key, $value, $ttl = 30) {
    $path = CACHE_DIR . '/' . md5($key) . '.json';
    $data = ['exp' => time()+$ttl, 'val' => $value];
    @file_put_contents($path, json_encode($data, JSON_UNESCAPED_UNICODE));
}
function cache_get($key) {
    $path = CACHE_DIR . '/' . md5($key) . '.json';
    if (!file_exists($path)) return null;
    $raw = @file_get_contents($path);
    if (!$raw) return null;
    $data = json_decode($raw, true);
    if (!$data || !isset($data['exp'])) return null;
    if (time() > intval($data['exp'])) return null;
    return $data['val'];
}

function http_get_json($url, $headers = []) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTPHEADER => array_merge([
            'Accept: application/json',
            'User-Agent: IranStarsBot/1.0'
        ], $headers),
    ]);
    $res = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($err) return [null, $err];
    return [json_decode($res, true), null];
}
function http_post_json($url, $body = null, $headers = []) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => array_merge([
            'Content-Type: application/json',
            'Accept: application/json',
            'User-Agent: IranStarsBot/1.0'
        ], $headers),
        CURLOPT_POSTFIELDS => $body ? json_encode($body, JSON_UNESCAPED_UNICODE) : '{}',
    ]);
    $res = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($err) return [null, $err];
    return [json_decode($res, true), null];
}

function get_setting($key, $default='1'){
    global $connect;
    $row = mysqli_fetch_assoc(mysqli_query($connect,"SELECT `value` FROM settings WHERE `key`='".mysqli_real_escape_string($connect,$key)."'"));
    return $row ? $row['value'] : $default;
}

function apply_profit($price){
    $p = @floatval(trim(@file_get_contents(__DIR__.'/sod.txt')));
    if ($p <= 0) return (int)$price;
    return (int)round($price * (1 + $p/100.0));
}

$kb_main = json_encode(["keyboard"=>[
    [['text'=>"♻️ استعلام شماره ها"],['text'=>"🛍 خرید شماره مجازی"]],
    [['text'=>"👤 حساب کاربری"],['text'=>"➕ افزایش موجودی"]],
    [['text'=>"⭐ خرید استارز/پرمیوم"],['text'=>"☎️ پشتیبانی"],['text'=>"❓راهنما"]],
    [['text'=>"💸 انتقال موجودی"]],
],'resize_keyboard'=>true]);

$back = json_encode(['keyboard'=>[[['text'=>"🔙 منو اصلی"]]],'resize_keyboard'=>true]);
$backp= json_encode(['keyboard'=>[[['text'=>"بازگشت"]]],'resize_keyboard'=>true]);

$panel=json_encode(['keyboard'=>[
    [['text'=>"آمار"],['text'=>"پیام همگانی"]],
    [['text'=>"تعیین درصد سود"]],
    [['text'=>"فعال/غیرفعال درگاه"],['text'=>"فعال/غیرفعال کارت‌به‌کارت"]],
    [['text'=>"درخواست‌های کارت‌به‌کارت"],['text'=>"پیگیری کاربر"]],
    [['text'=>"کاهش موجودی"],['text'=>"افزایش موجودی"]],
    [['text'=>"🔙 منو اصلی"]],
],'resize_keyboard'=>true]);

$join=json_encode(['inline_keyboard'=>[
    [['text'=>'📪 عضویت در کانال','url'=>"$channelink"]],
    [['text'=>'✅ عضو شدم','callback_data'=>'joined']],
]]);

$update  = json_decode(file_get_contents('php://input'));
$update2 = json_decode(file_get_contents('php://input'),true);

$message        = $update->message ?? null;
$callback_query = $update->callback_query ?? null;

$from_id    = $message->from->id ?? null;
$chat_id    = $message->chat->id ?? null;
$message_id = $message->message_id ?? null;
$text       = $message->text ?? null;
$caption    = $message->caption ?? null;
$username   = $message->from->username ?? null;

$chatid     = $callback_query->message->chat->id ?? null;
$messageid  = $callback_query->message->message_id ?? null;
$data       = $callback_query->data ?? null;
$membercall = $callback_query->id ?? null;

$photoid = null;
if(isset($update2['message']['photo'])){
    $photoid = $update2['message']['photo'][count($update2['message']['photo'])-1]['file_id'];
}

if ($from_id) {
    @mysqli_query($connect, "UPDATE user SET last_seen=NOW() WHERE id='".intval($from_id)."'");
}

$user  = $from_id ? mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '{$from_id}' LIMIT 1")) : null;
$user2 = $chatid ? mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '{$chatid}' LIMIT 1")) : null;

function telegram_menu_inline(){
    return json_encode(['inline_keyboard'=>[
        [['text'=>'📋 لیست (Panel 1 - معمولی)','callback_data'=>'tglist_p1_p1']],
        [['text'=>'📋 لیست (Panel 2 - بدون ریپورتی)','callback_data'=>'tglist_p2nr_p1']],
        [['text'=>'🔙 بازگشت','callback_data'=>'main_menu']]
    ]]);
}

function p1_prices($token){
    $cacheKey = 'p1_prices_1';
    if ($hit = cache_get($cacheKey)) return $hit;
    list($json,$err) = http_get_json(CALINOO_WEB_BASE . "/{$token}/get-prices/1?format=json");
    if ($err || !is_array($json)) return [];
    cache_set($cacheKey,$json,25);
    return $json;
}
function p1_getnum($token,$range){ return http_get_json(CALINOO_WEB_BASE . "/{$token}/getNumber/1/{$range}?format=json"); }
function p1_getcode($token,$req){  return http_get_json(CALINOO_WEB_BASE . "/{$token}/getCode/{$req}?format=json"); }
function p1_logout($token,$req){   return http_get_json(CALINOO_WEB_BASE . "/{$token}/logout/{$req}?format=json"); }

function p2_numbers($bearer){
    $cacheKey = 'p2_numbers_nr';
    if ($hit = cache_get($cacheKey)) return $hit;
    list($json,$err) = http_get_json(CALINOO_V2_BASE.'/telegram-numbers/numbers/', ["Authorization: Bearer {$bearer}"]);
    if ((!$json || (isset($json['status']) && $json['status']===false)) && !$err){
        list($json2,$err2) = http_post_json(CALINOO_V2_BASE.'/telegram-numbers/numbers/', ['none_report'=>true], ["Authorization: Bearer {$bearer}"]);
        if ($json2 && !$err2) $json=$json2;
    }
    if ($err || !is_array($json)) return [];
    $data = isset($json['data']) && is_array($json['data']) ? $json['data'] : $json;
    cache_set($cacheKey,$data,20);
    return $data;
}
function p2_order($bearer,$country_id){
    return http_post_json(CALINOO_V2_BASE.'/telegram-numbers/number-services/', ['country_id'=>$country_id,'none_report'=>true], ["Authorization: Bearer {$bearer}"]);
}
function p2_getcode($bearer,$order_id){
    $ch = curl_init();
    curl_setopt_array($ch,[
        CURLOPT_URL => CALINOO_V2_BASE.'/telegram-numbers/number-services/',
        CURLOPT_RETURNTRANSFER=>true,
        CURLOPT_CUSTOMREQUEST =>'GET',
        CURLOPT_HTTPHEADER => [
            'Accept: application/json',
            'Content-Type: application/json',
            "Authorization: Bearer {$bearer}",
        ],
        CURLOPT_POSTFIELDS => json_encode(['order_id'=>$order_id]),
        CURLOPT_TIMEOUT => 30
    ]);
    $res = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($err) return [null,$err];
    return [json_decode($res,true), null];
}
function p2_logout($bearer,$order_id){
    return http_post_json(CALINOO_V2_BASE.'/telegram-numbers/number-services/', ['order_id'=>$order_id], ["Authorization: Bearer {$bearer}"]);
}

function show_main($chat_id){
    sendmessage($chat_id,"سلام به ربات خوش آمدید ❣️\nیکی از گزینه‌ها را انتخاب کنید:",$GLOBALS['kb_main']);
}

function list_ui_rows($items, $cb_prefix){
    $kb = [];
    foreach ($items as $it){
        $country = $it['country'];
        $price   = apply_profit(intval($it['price'] ?? 0));
        $count   = $it['count'] ?? '';
        $id_or_rg= $it['id_or_rg'];

        // 3 ستونه (غیرقابل کلیک) + ردیف تایید خرید
        $kb[] = [
            ['text'=>$country,'callback_data'=>'noop'],
            ['text'=>number_format($price).' تومان','callback_data'=>'noop'],
            ['text'=>$count,'callback_data'=>'noop'],
        ];
        $kb[] = [
            ['text'=>"🛒 خرید {$country}",'callback_data'=>"{$cb_prefix}{$id_or_rg}"]
        ];
    }
    return $kb;
}

function paginate_row($prefix,$page,$pages){
    $row=[];
    if ($page>1) $row[]=['text'=>'◀️ قبلی','callback_data'=>$prefix.'_p'.($page-1)];
    if ($page<$pages) $row[]=['text'=>'بعدی ▶️','callback_data'=>$prefix.'_p'.($page+1)];
    return $row?[$row]:[];
}

function handle_list_p1($chatid,$messageid,$page){
    global $apicalino;
    $raw = p1_prices($apicalino);
    $items=[];
    foreach ($raw as $it){
        $items[]=[
            'country'=>$it['country'] ?? '',
            'price'  =>intval($it['price'] ?? 0),
            'count'  =>$it['count'] ?? '',
            'id_or_rg'=> strval($it['range'] ?? '')
        ];
    }
    // available first (by ✅ or 'available' or 'موجود')
    $avai=[];$nava=[];
    foreach($items as $x){
        $s=trim($x['count']); $ok=(strpos($s,'✅')!==false)||(strtolower($s)=='available')||($s=='موجود');
        if($ok) $avai[]=$x; else $nava[]=$x;
    }
    usort($avai, fn($a,$b)=> $a['price']<=>$b['price']);
    $items=array_merge($avai,$nava);

    $total=count($items); $pages=max(1,ceil($total/PAGE_SIZE)); $page=max(1,min($page,$pages));
    $slice=array_slice($items, ($page-1)*PAGE_SIZE, PAGE_SIZE);
    $kb = list_ui_rows($slice, 'confirm_p1_');
    foreach (paginate_row('tglist_p1',$page,$pages) as $r) $kb[]=$r;
    $kb[]=[['text'=>'🔙 بازگشت','callback_data'=>'main_menu']];

    bot('editMessageText',[
        'chat_id'=>$chatid,'message_id'=>$messageid,
        'text'=>"📋 لیست کشورها (Panel 1 — معمولی)\nصفحه {$page}/{$pages}\nقیمت‌ها با سود اعمال‌شده نمایش داده می‌شود.",
        'reply_markup'=>json_encode(['inline_keyboard'=>$kb])
    ]);
}

function handle_list_p2($chatid,$messageid,$page){
    global $calinooBearerToken;
    $raw = p2_numbers($calinooBearerToken);
    $items=[];
    foreach ($raw as $it){
        $items[]=[
            'country'=>$it['country'] ?? '',
            'price'  =>intval($it['price'] ?? 0),
            'count'  =>$it['count'] ?? '',
            'id_or_rg'=> ($it['id'] ?? '')!=='' ? ('id_'.$it['id']) : ('rg_'.strval($it['range'] ?? ''))
        ];
    }
    $avai=[];$nava=[];
    foreach($items as $x){
        $s=trim($x['count']); $ok=(strpos($s,'✅')!==false)||(strtolower($s)=='available')||($s=='موجود');
        if($ok) $avai[]=$x; else $nava[]=$x;
    }
    usort($avai, fn($a,$b)=> $a['price']<=>$b['price']);
    $items=array_merge($avai,$nava);

    $total=count($items); $pages=max(1,ceil($total/PAGE_SIZE)); $page=max(1,min($page,$pages));
    $slice=array_slice($items, ($page-1)*PAGE_SIZE, PAGE_SIZE);
    $kb = list_ui_rows($slice, 'confirm_p2_');
    foreach (paginate_row('tglist_p2nr',$page,$pages) as $r) $kb[]=$r;
    $kb[]=[['text'=>'🔙 بازگشت','callback_data'=>'main_menu']];

    bot('editMessageText',[
        'chat_id'=>$chatid,'message_id'=>$messageid,
        'text'=>"📋 لیست کشورها (Panel 2 — بدون ریپورتی)\nصفحه {$page}/{$pages}\nقیمت‌ها با سود اعمال‌شده نمایش داده می‌شود.",
        'reply_markup'=>json_encode(['inline_keyboard'=>$kb])
    ]);
}

function send_confirm_panel($chatid,$messageid,$mode,$id_or_rg){
    // mode: p1 or p2
    if ($mode==='p1'){
        $range = $id_or_rg;
        $title = "تأیید خرید (Panel 1)";
        $cb    = "buy_p1_{$range}";
    } else {
        if (strpos($id_or_rg,'id_')===0){ $title="تأیید خرید (Panel 2)"; $cb="buy_p2_id_".substr($id_or_rg,3); }
        else { $title="تأیید خرید (Panel 2 — جایگزین Panel1)"; $cb="buy_p2_rg_".substr($id_or_rg,3); }
    }
    $ik = json_encode(['inline_keyboard'=>[
        [['text'=>'✅ تایید خرید','callback_data'=>$cb]],
        [['text'=>'❌ انصراف','callback_data'=>'main_menu']]
    ]]);
    bot('editMessageText',[
        'chat_id'=>$chatid,'message_id'=>$messageid,
        'text'=>"{$title}\n\nبا تایید، شماره دریافت و فقط در زمان دریافت کد، وجه از کیف پول کسر می‌شود.",
        'reply_markup'=>$ik
    ]);
}

function stars_entry($chat_id){
    $ik = json_encode(['inline_keyboard'=>[[['text'=>'ورود به ربات ⭐','url'=>'https://t.me/IRAN_STARSBOT']]]]);
    sendMessage($chat_id,"برای خرید استارز و پرمیوم روی دکمه زیر بزنید:",$ik);
}

function zarinpal_enabled(){ return get_setting('payment_zarinpal_enabled','1')==='1'; }
function c2c_enabled(){ return get_setting('payment_card2card_enabled','1')==='1'; }

// -------------- Callback dispatcher --------------
if ($data){
    if ($data=='joined'){
        if (!join1($chatid)){
            bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'هنوز عضو کانال نیستید!','show_alert'=>true]);
        } else {
            sendmessage($chatid,'✅ عضویت شما تایید شد.',$kb_main);
        }
    }
    elseif ($data=='main_menu'){ show_main($chatid); }
    elseif (preg_match('~^tglist_p1_p(\d+)$~',$data,$m)){ handle_list_p1($chatid,$messageid,intval($m[1])); }
    elseif (preg_match('~^tglist_p2nr_p(\d+)$~',$data,$m)){ handle_list_p2($chatid,$messageid,intval($m[1])); }

    // tap country → confirm sheet
    elseif (preg_match('~^confirm_p1_(\d+)$~',$data,$m)){ send_confirm_panel($chatid,$messageid,'p1',$m[1]); }
    elseif (preg_match('~^confirm_p2_(.+)$~',$data,$m)){ send_confirm_panel($chatid,$messageid,'p2',$m[1]); }

    // purchases
    elseif (preg_match('~^buy_p1_(\d+)$~',$data,$m)){
        global $connect,$user2,$apicalino;
        $range=$m[1];
        // price check for balance visualization (not deduction yet)
        $raw = p1_prices($apicalino);
        $match=null;
        foreach($raw as $it){ if (strval($it['range']??'')===strval($range)){ $match=$it; break; } }
        if (!$match){ sendMessage($chatid,"⛔️ کشور یافت نشد."); exit; }
        $price = apply_profit(intval($match['price']??0));
        if ($user2['coin'] < $price){
            bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'❌ موجودی کافی نیست!','show_alert'=>true]);
            exit;
        }
        list($json,$err) = p1_getnum($apicalino,$range);
        if ($err || !isset($json['number'])){
            $why = $json['error_msg'] ?? 'نامشخص';
            sendMessage($chatid,"⛔️ خطا در دریافت شماره (P1): {$why}");
            exit;
        }
        $number = $json['number']; $req = $json['request_id'] ?? ''; $quality=$json['quality'] ?? '—';
        $price  = apply_profit(intval($json['price'] ?? $price));
        $order_code = uniqid('ORD_', true);
        mysqli_query($connect,"INSERT INTO orders (order_code,chat_id,service,country,phone_number,price,request_id) VALUES
            ('{$order_code}','{$chatid}','telegram','{$match['country']}','{$number}','{$price}','{$req}')");
        $msg="✅ شماره مجازی دریافت شد (Panel 1)\n\n📞 {$number}\n🌍 {$match['country']}\n💰 ".number_format($price)." تومان\nℹ️ کیفیت: {$quality}\n\n❗️ وجه زمانی کسر می‌شود که کد دریافت شود.";
        $ik=json_encode(['inline_keyboard'=>[
            [['text'=>'♻️ دریافت کد','callback_data'=>"p1_code_{$order_code}"]],
            [['text'=>'🚪 خروج از اکانت','callback_data'=>"p1_logout_{$req}|{$order_code}"]],
            [['text'=>'🔙 منو اصلی','callback_data'=>'main_menu']]
        ]]);
        sendMessage($chatid,$msg,$ik);
    }
    elseif (preg_match('~^buy_p2_id_(\d+)$~',$data,$m)){
        global $connect,$user2,$calinooBearerToken;
        $cid=$m[1];
        $items=p2_numbers($calinooBearerToken);
        $match=null; foreach($items as $it){ if (strval($it['id']??'')===strval($cid)){ $match=$it; break; } }
        $country=$match['country'] ?? 'کشور';
        $price  = apply_profit(intval($match['price'] ?? 0));
        if ($price>0 && $user2['coin'] < $price){
            bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'❌ موجودی کافی نیست!','show_alert'=>true]);
            exit;
        }
        list($json,$err)=p2_order($calinooBearerToken,$cid);
        if ($err || !$json || ($json['status']??false)===false){
            $why = $json['message'] ?? 'نامشخص';
            sendMessage($chatid,"⛔️ خطا در دریافت شماره (P2): {$why}");
            exit;
        }
        $data=$json['data'] ?? [];
        $number=$data['number'] ?? '';
        $order_id=$data['order_id'] ?? '';
        $p = apply_profit(intval($data['price'] ?? $price));
        $range = $data['range'] ?? ($match['range'] ?? '');
        $quality = $data['quality'] ?? 'سالم بدون ریپورت';
        $countryHuman = $data['countery'] ?? $country;
        $order_code=uniqid('ORD_',true);
        mysqli_query($connect,"INSERT INTO orders (order_code,chat_id,service,country,phone_number,price,request_id) VALUES
            ('{$order_code}','{$chatid}','telegram','{$countryHuman}','{$number}','{$p}','{$order_id}')");
        $msg="✅ شماره مجازی دریافت شد (Panel 2 - بدون ریپورتی)\n\n📞 {$number}\n🌍 {$countryHuman}\n📶 رنج: {$range}\n💰 ".number_format($p)." تومان\n🛡 کیفیت: {$quality}\n\n❗️ وجه زمانی کسر می‌شود که کد دریافت شود.";
        $ik=json_encode(['inline_keyboard'=>[
            [['text'=>'♻️ دریافت کد','callback_data'=>"p2_code_{$order_code}"]],
            [['text'=>'🚪 خروج از اکانت','callback_data'=>"p2_logout_{$order_id}|{$order_code}"]],
            [['text'=>'🔙 منو اصلی','callback_data'=>'main_menu']]
        ]]);
        sendMessage($chatid,$msg,$ik);
    }
    elseif (preg_match('~^buy_p2_rg_(\d+)$~',$data,$m)){
        // fallback to panel1 by range
        $_POST['callback_query_id']=$membercall;
        // reuse p1 flow
        $range=$m[1];
        // redirect to buy_p1
        header("X-Accel-Redirect: /"); // no-op
        // Call directly
        // (we keep code simple by duplicating)
        global $connect,$user2,$apicalino;
        $raw = p1_prices($apicalino);
        $match=null;
        foreach($raw as $it){ if (strval($it['range']??'')===strval($range)){ $match=$it; break; } }
        if (!$match){ sendMessage($chatid,"⛔️ کشور یافت نشد."); exit; }
        $price = apply_profit(intval($match['price']??0));
        if ($user2['coin'] < $price){
            bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'❌ موجودی کافی نیست!','show_alert'=>true]);
            exit;
        }
        list($json,$err) = p1_getnum($apicalino,$range);
        if ($err || !isset($json['number'])){
            $why = $json['error_msg'] ?? 'نامشخص';
            sendMessage($chatid,"⛔️ خطا در دریافت شماره (fallback P1): {$why}");
            exit;
        }
        $number = $json['number']; $req = $json['request_id'] ?? ''; $quality=$json['quality'] ?? '—';
        $price  = apply_profit(intval($json['price'] ?? $price));
        $order_code = uniqid('ORD_', true);
        mysqli_query($connect,"INSERT INTO orders (order_code,chat_id,service,country,phone_number,price,request_id) VALUES
            ('{$order_code}','{$chatid}','telegram','{$match['country']}','{$number}','{$price}','{$req}')");
        $msg="✅ شماره مجازی دریافت شد (Panel 2 — جایگزین Panel1)\n\n📞 {$number}\n🌍 {$match['country']}\n💰 ".number_format($price)." تومان\nℹ️ کیفیت: {$quality}\n\n❗️ وجه زمانی کسر می‌شود که کد دریافت شود.";
        $ik=json_encode(['inline_keyboard'=>[
            [['text'=>'♻️ دریافت کد','callback_data'=>"p1_code_{$order_code}"]],
            [['text'=>'🚪 خروج از اکانت','callback_data'=>"p1_logout_{$req}|{$order_code}"]],
            [['text'=>'🔙 منو اصلی','callback_data'=>'main_menu']]
        ]]);
        sendMessage($chatid,$msg,$ik);
    }

    // get code / logout
    elseif (preg_match('~^p1_code_(.+)$~',$data,$m)){
        global $connect,$apicalino,$membercall;
        $order_code=$m[1];
        $o=mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM orders WHERE order_code='{$order_code}' LIMIT 1"));
        if(!$o){ bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'⛔️ سفارش یافت نشد!','show_alert'=>true]); exit; }
        list($resp,$err)=p1_getcode($apicalino,$o['request_id']);
        if($err||!$resp){ bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'خطا در سرویس!','show_alert'=>true]); exit; }
        if(isset($resp['code']) && $resp['code']!==''){
            $price=floatval($o['price']);
            if ($o['status']!='complete'){
                mysqli_query($connect,"UPDATE user SET coin=coin-{$price} WHERE id='{$o['chat_id']}'");
                mysqli_query($connect,"UPDATE orders SET status='complete' WHERE order_code='{$order_code}'");
            }
            $msg="شماره شما: {$o['phone_number']}\nکشور: {$o['country']}\nکد تایید: {$resp['code']}\nقیمت: ".number_format($price)." تومان\n\n✅ کد دریافت شد!";
            $ik=json_encode(['inline_keyboard'=>[
                [['text'=>'♻️ دریافت مجدد کد','callback_data'=>"p1_code_{$order_code}"]],
                [['text'=>'🚪 خروج از اکانت','callback_data'=>"p1_logout_{$o['request_id']}|{$order_code}"]],
            ]]);
            bot('editMessageText',['chat_id'=>$chatid,'message_id'=>$messageid,'text'=>$msg,'reply_markup'=>$ik]);
            bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'کد دریافت شد ✅','show_alert'=>true]);
        } else {
            $err_code = $resp['error_code'] ?? '';
            if ($err_code==='wait_code'){
                bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'⏳ هنوز کدی نیامده؛ کمی بعد تلاش کنید.','show_alert'=>true]);
            } else {
                $why=$resp['error_msg'] ?? 'نامشخص';
                bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>"خطا: {$why}",'show_alert'=>true]);
            }
        }
    }
    elseif (preg_match('~^p2_code_(.+)$~',$data,$m)){
        global $connect,$calinooBearerToken,$membercall;
        $order_code=$m[1];
        $o=mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM orders WHERE order_code='{$order_code}' LIMIT 1"));
        if(!$o){ bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'⛔️ سفارش یافت نشد!','show_alert'=>true]); exit; }
        list($resp,$err)=p2_getcode($calinooBearerToken,$o['request_id']);
        if($err||!$resp){ bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'خطا در سرویس!','show_alert'=>true]); exit; }
        if(($resp['status']??false) && isset($resp['data']['code'])){
            $code=$resp['data']['code']; $price=floatval($o['price']);
            if ($o['status']!='complete'){
                mysqli_query($connect,"UPDATE user SET coin=coin-{$price} WHERE id='{$o['chat_id']}'");
                mysqli_query($connect,"UPDATE orders SET status='complete' WHERE order_code='{$order_code}'");
            }
            $msg="شماره شما: {$o['phone_number']}\nکشور: {$o['country']}\nکد تایید: {$code}\nقیمت: ".number_format($price)." تومان\n\n✅ کد دریافت شد!";
            $ik=json_encode(['inline_keyboard'=>[
                [['text'=>'♻️ دریافت مجدد کد','callback_data'=>"p2_code_{$order_code}"]],
                [['text'=>'🚪 خروج از اکانت','callback_data'=>"p2_logout_{$o['request_id']}|{$order_code}"]],
            ]]);
            bot('editMessageText',['chat_id'=>$chatid,'message_id'=>$messageid,'text'=>$msg,'reply_markup'=>$ik]);
            bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'کد دریافت شد ✅','show_alert'=>true]);
        } else {
            $status_code=intval($resp['status_code'] ?? 0);
            if ($status_code===202){
                bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'⏳ هنوز کدی نیامده؛ کمی بعد تلاش کنید.','show_alert'=>true]);
            } else {
                $why=$resp['message'] ?? 'نامشخص';
                bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>"خطا: {$why}",'show_alert'=>true]);
            }
        }
    }
    elseif (preg_match('~^p1_logout_(.+)\|(.+)$~',$data,$m)){
        global $apicalino,$membercall;
        list($resp,$err)=p1_logout($apicalino,$m[1]);
        $ok=(!$err && $resp && (($resp['success'] ?? false)===true));
        $ik=json_encode(['inline_keyboard'=>[[['text'=>'🔙 منو اصلی','callback_data'=>'main_menu']]]]);
        if($ok){
            bot('editMessageText',['chat_id'=>$chatid,'message_id'=>$messageid,'text'=>"✅ خروج انجام شد.",'reply_markup'=>$ik]);
            bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'خروج موفق ✅','show_alert'=>true]);
        } else {
            $why=$resp['error_msg'] ?? 'نامشخص';
            bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>"خطا: {$why}",'show_alert'=>true]);
        }
    }
    elseif (preg_match('~^p2_logout_(.+)\|(.+)$~',$data,$m)){
        global $calinooBearerToken,$membercall;
        list($resp,$err)=p2_logout($calinooBearerToken,$m[1]);
        $ok=(!$err && $resp && (($resp['status'] ?? false)===true));
        $ik=json_encode(['inline_keyboard'=>[[['text'=>'🔙 منو اصلی','callback_data'=>'main_menu']]]]);
        if($ok){
            bot('editMessageText',['chat_id'=>$chatid,'message_id'=>$messageid,'text'=>"✅ خروج انجام شد.",'reply_markup'=>$ik]);
            bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'خروج موفق ✅','show_alert'=>true]);
        } else {
            $why=$resp['message'] ?? 'نامشخص';
            bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>"خطا: {$why}",'show_alert'=>true]);
        }
    }

    // admin approve/reject topup
    elseif (preg_match('~^topup_approve_(\d+)$~',$data,$m)){
        global $connect,$membercall;
        $id=intval($m[1]);
        $row=mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM topup_requests WHERE id={$id} AND status='pending'"));
        if(!$row){ bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'یافت نشد/بررسی شده.','show_alert'=>true]); exit; }
        mysqli_query($connect,"UPDATE user SET coin=coin+{$row['amount']} WHERE id='{$row['chat_id']}'");
        mysqli_query($connect,"UPDATE topup_requests SET status='approved', decided_at=NOW(), admin_id='{$chatid}' WHERE id={$id}");
        sendMessage($row['chat_id'],"✅ واریز کارت‌به‌کارت شما تایید شد. مبلغ ".number_format($row['amount'])." تومان به موجودی افزوده شد.");
        bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'تایید شد ✅','show_alert'=>true]);
    }
    elseif (preg_match('~^topup_reject_(\d+)$~',$data,$m)){
        global $connect,$membercall;
        $id=intval($m[1]);
        $row=mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM topup_requests WHERE id={$id} AND status='pending'"));
        if(!$row){ bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'یافت نشد/بررسی شده.','show_alert'=>true]); exit; }
        mysqli_query($connect,"UPDATE topup_requests SET status='rejected', decided_at=NOW(), admin_id='{$chatid}' WHERE id={$id}");
        sendMessage($row['chat_id'],"❌ واریز کارت‌به‌کارت شما رد شد. لطفاً با پشتیبانی در تماس باشید.");
        bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'رد شد ❌','show_alert'=>true]);
    }
}

// -------------- Message dispatcher --------------
if ($text){

    if ($text=='/start' || $text=='🔙 منو اصلی'){
        if(!$user){ mysqli_query($connect,"INSERT INTO user (id,step) VALUES ('{$chat_id}','none')"); }
        mysqli_query($connect,"UPDATE user SET step='none' WHERE id='{$chat_id}'");
        if (!join1($chat_id)){ sendMessage($chat_id,"⚠️ ابتدا عضو کانال شوید:",$join); exit; }
        show_main($chat_id); exit;
    }

    if (!join1($chat_id)){ sendMessage($chat_id,"⚠️ ابتدا عضو کانال شوید:",$join); exit; }

    if ($text=='🛍 خرید شماره مجازی' || $text=='♻️ استعلام شماره ها'){
        sendMessage($chat_id,"گزینه مورد نظر را انتخاب کنید:", telegram_menu_inline()); exit;
    }

    if ($text=='⭐ خرید استارز/پرمیوم'){ stars_entry($chat_id); exit; }

    // Increase balance
    if ($text=='➕ افزایش موجودی'){
        $rows=[];
        if (zarinpal_enabled()) $rows[] = [['text'=>'💵 درگاه بانکی','callback_data'=>'zarinpal']];
        if (c2c_enabled())     $rows[] = [['text'=>'💳 کارت‌به‌کارت','callback_data'=>'c2c_start']];
        if (!$rows) { sendMessage($chat_id,"⛔️ هیچ روش پرداختی فعال نیست."); exit; }
        $ik=json_encode(['inline_keyboard'=>$rows]);
        sendMessage($chat_id,"روش افزایش موجودی را انتخاب کنید:",$ik); exit;
    }

    // Account
    if ($text=='👤 حساب کاربری'){
        include_once 'jdf.php';
        $join_date = jdate('Y/m/d', strtotime($user['created_at']));
        $orders = mysqli_fetch_assoc(mysqli_query($connect,"SELECT COUNT(*) as c FROM orders WHERE chat_id='{$chat_id}' AND status='complete'"));
        $sum    = mysqli_fetch_assoc(mysqli_query($connect,"SELECT SUM(price) as t FROM orders WHERE chat_id='{$chat_id}' AND status='complete'"));
        $coin = number_format($user['coin']);
        $msg="👤 شناسه: {$chat_id}\n📆 عضویت: {$join_date}\n🛍 سفارشات: {$orders['c']}\n💳 خریدها: ".number_format($sum['t']??0)." تومان\n💰 موجودی: {$coin} تومان";
        $ik=json_encode(['inline_keyboard'=>[
            [['text'=>'📜 سوابق خرید','callback_data'=>'purchase_history']],
        ]]);
        sendMessage($chat_id,$msg,$ik); exit;
    }

    if ($text=='❓راهنما'){
        sendMessage($chat_id,"راهنما:\n- از استعلام/خرید شماره استفاده کنید.\n- هنگام دریافت کد، وجه کسر می‌شود.\n- برای افزایش موجودی از درگاه یا کارت‌به‌کارت اقدام کنید."); exit;
    }
    if ($text=='☎️ پشتیبانی'){
        sendMessage($chat_id,"پشتیبانی: @IRAN_STARS_SUPPORT"); exit;
    }

    // transfer
    if ($text=='💸 انتقال موجودی'){
        mysqli_query($connect,"UPDATE user SET step='transfer_id' WHERE id='{$chat_id}'");
        sendMessage($chat_id,"آیدی عددی گیرنده را وارد کنید:",$back); exit;
    }
    if ($user['step']=='transfer_id' && is_numeric($text)){
        $target = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id='{$text}'"));
        if(!$target){ sendMessage($chat_id,"❌ کاربر یافت نشد."); exit; }
        mysqli_query($connect,"UPDATE user SET step='transfer_amount', temp='{$text}' WHERE id='{$chat_id}'");
        sendMessage($chat_id,"مبلغ به تومان:",$back); exit;
    }
    if ($user['step']=='transfer_amount' && is_numeric($text)){
        $amount=intval($text); $to=$user['temp'];
        if ($user['coin'] < $amount){
            sendMessage($chat_id,"❌ موجودی کافی نیست! فعلی: ".number_format($user['coin'])." تومان",$kb_main);
            mysqli_query($connect,"UPDATE user SET step='none' WHERE id='{$chat_id}'"); exit;
        }
        mysqli_query($connect,"UPDATE user SET coin=coin-{$amount}, step='none', temp='' WHERE id='{$chat_id}'");
        mysqli_query($connect,"UPDATE user SET coin=coin+{$amount} WHERE id='{$to}'");
        sendMessage($chat_id,"✅ انتقال شد: ".number_format($amount)." تومان",$kb_main);
        sendMessage($to,"🎁 مبلغ ".number_format($amount)." تومان از طرف {$chat_id} برای شما واریز شد.");
        exit;
    }
}

// Inline payments callbacks
if ($data){
    if ($data=='zarinpal'){
        mysqli_query($connect,"UPDATE user SET step='zarinpal' WHERE id='{$chatid}'");
        sendMessage($chatid,"💰 مبلغ به تومان را وارد کنید:",$back);
    }
    elseif ($user2 && $user2['step']=='zarinpal' && isset($message->text) && $chat_id==$chatid){
        $amount=intval($message->text);
        if ($amount<1000){ sendMessage($chatid,"حداقل 1000 تومان."); exit; }
        if ($amount>100000 && $user2['verify']!='yes'){
            sendMessage($chatid,"برای مبالغ بالا احراز هویت لازم است."); exit;
        }
        $url = "https://iranstarsz.s14.viptelbot.top/bot/payz.php?amount={$amount}&chat={$chatid}";
        $ik=json_encode(['inline_keyboard'=>[[['text'=>'پرداخت','url'=>$url]]]]);
        sendMessage($chatid,"برای پرداخت ".number_format($amount)." تومان روی دکمه بزن:",$ik);
        mysqli_query($connect,"UPDATE user SET step='none' WHERE id='{$chatid}'");
    }
    elseif ($data=='c2c_start'){
        mysqli_query($connect,"UPDATE user SET step='c2c_amount' WHERE id='{$chatid}'");
        sendMessage($chatid,"مبلغ واریزی کارت‌به‌کارت (تومان) را وارد کنید:",$back);
    }
    elseif ($user2 && $user2['step']=='c2c_amount' && isset($message->text) && $chat_id==$chatid){
        if (!is_numeric($message->text) || intval($message->text)<1000){ sendMessage($chatid,"حداقل مبلغ 1000 تومان است."); exit; }
        mysqli_query($connect,"UPDATE user SET step='c2c_wait_photo', temp='".intval($message->text)."' WHERE id='{$chatid}'");
        sendMessage($chatid,"🖼 عکس فیش واریزی را ارسال کنید:",$back);
    }
    elseif ($user2 && $user2['step']=='c2c_wait_photo' && $photoid && $chatid==$from_id){
        $amount = intval($user2['temp']);
        mysqli_query($connect,"INSERT INTO topup_requests (chat_id,amount,photo_file_id) VALUES ('{$chatid}','{$amount}','{$photoid}')");
        mysqli_query($connect,"UPDATE user SET step='none', temp='' WHERE id='{$chatid}'");
        sendMessage($chatid,"✅ درخواست شما ثبت شد و پس از تایید مدیریت، به موجودی اضافه می‌شود.");
        // notify admins
        $admins=[1283220206,7928656503];
        foreach($admins as $ad){
            bot('sendPhoto',[
                'chat_id'=>$ad,'photo'=>$photoid,
                'caption'=>"درخواست کارت‌به‌کارت جدید\nکاربر: {$chatid}\nمبلغ: ".number_format($amount)." تومان",
                'reply_markup'=>json_encode(['inline_keyboard'=>[
                    [['text'=>'✅ تایید','callback_data'=>'topup_approve_'.mysqli_insert_id($connect)]],
                    [['text'=>'❌ رد','callback_data'=>'topup_reject_'.mysqli_insert_id($connect)]],
                ]])
            ]);
        }
    }
}

// Purchase history
if ($data=='purchase_history'){
    include_once 'jdf.php';
    $q=mysqli_query($connect,"SELECT * FROM orders WHERE chat_id='{$chatid}' AND status='complete' ORDER BY created_at DESC LIMIT 20");
    if (mysqli_num_rows($q)==0){
        bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'هیچ سفارشی ثبت نشده.','show_alert'=>true]);
    } else {
        $msg="🛍 آخرین خریدها:\n\n";
        while($r=mysqli_fetch_assoc($q)){
            $msg.="📞 {$r['phone_number']} | {$r['country']}\n💰 ".number_format($r['price'])." تومان\n⏰ ".jdate('Y/m/d H:i',strtotime($r['created_at']))."\n———\n";
        }
        sendMessage($chatid,$msg,null);
    }
}

// ---------------- Admin Panel ----------------
$ADMINS=['1283220206','7928656503'];
if (in_array($chat_id,$ADMINS)){
    if ($text=='/panel' || $text=='بازگشت' || $text=='🔙 منو اصلی'){
        mysqli_query($connect,"UPDATE user SET step='none' WHERE id='{$chat_id}'");
        sendMessage($chat_id,"مدیریت:",$panel);
    }
    elseif ($text=='آمار'){
        $users=mysqli_num_rows(mysqli_query($connect,"SELECT id FROM user"));
        $orders=mysqli_num_rows(mysqli_query($connect,"SELECT id FROM orders"));
        $sum = mysqli_fetch_assoc(mysqli_query($connect,"SELECT SUM(price) as t FROM orders WHERE status='complete'"));
        sendMessage($chat_id,"👥 کاربران: {$users}\n🛒 سفارشات: {$orders}\n💰 فروش کل: ".number_format($sum['t']??0)." تومان");
    }
    elseif ($text=='تعیین درصد سود'){
        mysqli_query($connect,"UPDATE user SET step='setsod' WHERE id='{$chat_id}'");
        sendMessage($chat_id,"درصد سود را بفرستید (مثلاً 20):",$backp);
    }
    elseif ($user['step']=='setsod'){
        if(!is_numeric($text)){ sendMessage($chat_id,"فقط عدد."); }
        else { file_put_contents(__DIR__.'/sod.txt',$text); mysqli_query($connect,"UPDATE user SET step='none' WHERE id='{$chat_id}'"); sendMessage($chat_id,"تنظیم شد ✅",$panel); }
    }
    elseif ($text=='فعال/غیرفعال درگاه'){
        $cur=zarinpal_enabled()?'1':'0'; $new=$cur==='1'?'0':'1';
        mysqli_query($connect,"INSERT INTO settings (`key`,`value`) VALUES('payment_zarinpal_enabled','{$new}') ON DUPLICATE KEY UPDATE `value`='{$new}'");
        sendMessage($chat_id, $new==='1'?'درگاه فعال شد ✅':'درگاه غیرفعال شد ❌', $panel);
    }
    elseif ($text=='فعال/غیرفعال کارت‌به‌کارت'){
        $cur=c2c_enabled()?'1':'0'; $new=$cur==='1'?'0':'1';
        mysqli_query($connect,"INSERT INTO settings (`key`,`value`) VALUES('payment_card2card_enabled','{$new}') ON DUPLICATE KEY UPDATE `value`='{$new}'");
        sendMessage($chat_id, $new==='1'?'کارت‌به‌کارت فعال شد ✅':'کارت‌به‌کارت غیرفعال شد ❌', $panel);
    }
    elseif ($text=='درخواست‌های کارت‌به‌کارت'){
        $q=mysqli_query($connect,"SELECT * FROM topup_requests WHERE status='pending' ORDER BY created_at ASC LIMIT 10");
        if (mysqli_num_rows($q)==0){ sendMessage($chat_id,"درخواستی وجود ندارد."); }
        else {
            while($r=mysqli_fetch_assoc($q)){
                bot('sendMessage',[
                    'chat_id'=>$chat_id,
                    'text'=>"کاربر: {$r['chat_id']}\nمبلغ: ".number_format($r['amount'])." تومان\nزمان: {$r['created_at']}",
                    'reply_markup'=>json_encode(['inline_keyboard'=>[
                        [['text'=>'✅ تایید','callback_data'=>'topup_approve_'.$r['id']]],
                        [['text'=>'❌ رد','callback_data'=>'topup_reject_'.$r['id']]],
                    ]])
                ]);
            }
        }
    }
    elseif ($text=='پیگیری کاربر'){
        mysqli_query($connect,"UPDATE user SET step='trace_user' WHERE id='{$chat_id}'");
        sendMessage($chat_id,"آیدی عددی یا @یوزرنیم کاربر را ارسال کنید:",$backp);
    }
    elseif ($user['step']=='trace_user'){
        $query = is_numeric($text) ? "id='".intval($text)."'" : "username='".mysqli_real_escape_string($connect,ltrim($text,'@'))."'";
        $u=mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE {$query} LIMIT 1"));
        if(!$u){ sendMessage($chat_id,"کاربر یافت نشد."); }
        else{
            $orders = mysqli_query($connect,"SELECT * FROM orders WHERE chat_id='{$u['id']}' ORDER BY created_at DESC LIMIT 10");
            $tops   = mysqli_query($connect,"SELECT * FROM topup_requests WHERE chat_id='{$u['id']}' ORDER BY created_at DESC LIMIT 10");
            $msg="👤 {$u['id']} (@{$u['username']})\nعضویت: {$u['created_at']}\nآخرین حضور: {$u['last_seen']}\nموجودی: ".number_format($u['coin'])." تومان\n\n— واریزی‌ها:\n";
            if (mysqli_num_rows($tops)==0) $msg.="(هیچ)\n"; else while($t=mysqli_fetch_assoc($tops)){ $msg.="- ".number_format($t['amount'])." | {$t['status']} | {$t['created_at']}\n"; }
            $msg.="\n— سفارش‌ها:\n";
            if (mysqli_num_rows($orders)==0) $msg.="(هیچ)\n"; else while($o=mysqli_fetch_assoc($orders)){ $msg.="- {$o['phone_number']} | {$o['country']} | ".number_format($o['price'])." | {$o['status']} | {$o['created_at']}\n"; }
            sendMessage($chat_id,$msg,$panel);
        }
        mysqli_query($connect,"UPDATE user SET step='none' WHERE id='{$chat_id}'");
    }
    elseif ($text=='پیام همگانی'){
        mysqli_query($connect,"UPDATE user SET step='bc' WHERE id='{$chat_id}'");
        sendMessage($chat_id,"متن/عکس ارسال کنید:",$backp);
    }
    elseif ($user['step']=='bc'){
        $txt=$caption?:$text; $ph=$photoid??null;
        $us=mysqli_query($connect,"SELECT id FROM user");
        $i=0; while($r=mysqli_fetch_assoc($us)){
            if($ph) bot('sendPhoto',['chat_id'=>$r['id'],'photo'=>$ph,'caption'=>$txt]);
            else sendMessage($r['id'],$txt);
            $i++; if($i%25==0) usleep(300000);
        }
        mysqli_query($connect,"UPDATE user SET step='none' WHERE id='{$chat_id}'");
        sendMessage($chat_id,"✅ ارسال شد برای {$i} کاربر.",$panel);
    }
    elseif ($text=='افزایش موجودی'){
        mysqli_query($connect,"UPDATE user SET step='adm_add_id' WHERE id='{$chat_id}'");
        sendMessage($chat_id,"آیدی عددی کاربر:",$backp);
    }
    elseif ($user['step']=='adm_add_id' && is_numeric($text)){
        mysqli_query($connect,"UPDATE user SET step='adm_add_amount', temp='{$text}' WHERE id='{$chat_id}'");
        sendMessage($chat_id,"مبلغ (تومان):",$backp);
    }
    elseif ($user['step']=='adm_add_amount' && is_numeric($text)){
        $uid=$user['temp']; $amt=intval($text);
        mysqli_query($connect,"UPDATE user SET coin=coin+{$amt}, step='none', temp='' WHERE id='{$chat_id}'");
        sendMessage($uid,"💰 مبلغ ".number_format($amt)." تومان توسط مدیریت به کیف پول شما اضافه شد.");
        sendMessage($chat_id,"✅ انجام شد.",$panel);
    }
    elseif ($text=='کاهش موجودی'){
        mysqli_query($connect,"UPDATE user SET step='adm_sub_id' WHERE id='{$chat_id}'");
        sendMessage($chat_id,"آیدی عددی کاربر:",$backp);
    }
    elseif ($user['step']=='adm_sub_id' && is_numeric($text)){
        mysqli_query($connect,"UPDATE user SET step='adm_sub_amount', temp='{$text}' WHERE id='{$chat_id}'");
        sendMessage($chat_id,"مبلغ (تومان):",$backp);
    }
    elseif ($user['step']=='adm_sub_amount' && is_numeric($text)){
        $uid=$user['temp']; $amt=intval($text);
        mysqli_query($connect,"UPDATE user SET coin=coin-{$amt}, step='none', temp='' WHERE id='{$chat_id}'");
        sendMessage($chat_id,"✅ انجام شد.",$panel);
    }
}

?>