CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  tg_id BIGINT UNIQUE,
  full_name VARCHAR(255),
  balance BIGINT DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS panels (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(100),
  api_key TEXT,
  base_currency VARCHAR(10) DEFAULT 'toman',
  profit_percent DECIMAL(5,2) DEFAULT 15.00,
  enabled TINYINT(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS services (
  id INT AUTO_INCREMENT PRIMARY KEY,
  panel_id INT,
  code VARCHAR(50),
  name VARCHAR(100),
  base_price_toman INT,
  FOREIGN KEY (panel_id) REFERENCES panels(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS inventory (
  id INT AUTO_INCREMENT PRIMARY KEY,
  service_id INT,
  country_code VARCHAR(10),
  country_name VARCHAR(100),
  stock INT DEFAULT 0,
  last_sync TIMESTAMP NULL DEFAULT NULL,
  UNIQUE KEY uniq_srv_country (service_id, country_code),
  FOREIGN KEY (service_id) REFERENCES services(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS payments (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT,
  panel_id INT,
  service_id INT,
  country_code VARCHAR(10),
  amount_toman INT,
  amount_rial INT,
  authority VARCHAR(128) UNIQUE,
  ref_id VARCHAR(128),
  status ENUM('pending','paid','failed') DEFAULT 'pending',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  FOREIGN KEY (user_id) REFERENCES users(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
