<?php
/**
 * ورودی: pid (payment id) یا پارامترهای ضروری برای ساخت payment
 * خروجی: ریدایرکت به درگاه یا پیام خطا
 */
require_once __DIR__.'/../lib/bootstrap.php';
require_once __DIR__.'/../lib/config.php';
require_once __DIR__.'/../lib/payments.php';

// ورودی نمونه: ?user=1&panel=1&service=2&country=US&price=66000
$user_id   = (int)($_GET['user'] ?? 0);
$panel_id  = (int)($_GET['panel'] ?? 0);
$service_id= (int)($_GET['service'] ?? 0);
$country   = preg_replace('/[^A-Za-z]/','', $_GET['country'] ?? '');
$price_tmn = (int)($_GET['price'] ?? 0);

if (!$user_id || !$panel_id || !$service_id || !$country || !$price_tmn) {
  http_response_code(400); echo "bad input"; exit;
}

$amount_rial = $price_tmn * 10;

$pdo->beginTransaction();
$stmt = $pdo->prepare("INSERT INTO payments(user_id, panel_id, service_id, country_code, amount_toman, amount_rial, status) VALUES(?,?,?,?,?,?, 'pending')");
$stmt->execute([$user_id,$panel_id,$service_id,$country,$price_tmn,$amount_rial]);
$pid = (int)$pdo->lastInsertId();
$pdo->commit();

$cb = ZARINPAL_CALLBACK_URL;
if (!$cb) { http_response_code(500); echo "callback not set"; exit; }
$callback_url = $cb.(str_contains($cb,'?')?'&':'?')."pid=".$pid;

$req = zarin_request($amount_rial, $callback_url);
if (!$req['ok']) { http_response_code(500); echo "zarin request failed"; exit; }

$authority = $req['authority'];
$stmt = $pdo->prepare("UPDATE payments SET authority=:a WHERE id=:id AND status='pending'");
$stmt->execute([':a'=>$authority, ':id'=>$pid]);

// Redirect to gateway
$gateway = "https://www.zarinpal.com/pg/StartPay/".$authority;
header("Location: $gateway");
exit;
