<?php
require_once __DIR__.'/config.php';

function tg_api(string $method, array $params = []) {
  $url = "https://api.telegram.org/bot".BOT_TOKEN."/".$method;
  $ch = curl_init($url);
  curl_setopt_array($ch,[
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 15,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $params,
  ]);
  $res = curl_exec($ch);
  if ($res === false) return null;
  return json_decode($res, true);
}

function tg_sendMessage($chat_id, $text, $reply_markup = null) {
  $params = ['chat_id'=>$chat_id,'text'=>$text,'parse_mode'=>'HTML'];
  if ($reply_markup) $params['reply_markup'] = json_encode($reply_markup, JSON_UNESCAPED_UNICODE);
  return tg_api('sendMessage', $params);
}
