<?php
function compute_price_toman(int $base_toman, float $profit_percent): int {
  $price = $base_toman * (1 + $profit_percent / 100.0);
  return (int) round($price);
}

function inv_get_countries(PDO $pdo, int $service_id): array {
  $stmt = $pdo->prepare("SELECT country_code, country_name, stock FROM inventory WHERE service_id = :sid ORDER BY country_name");
  $stmt->execute([':sid'=>$service_id]);
  return $stmt->fetchAll();
}

function inv_status_emoji(int $stock): string {
  if ($stock <= 0) return "🔴";
  if ($stock < 100) return "🟡";
  return "🟢";
}
