<?php
/**
 * نمونه هندلرهای منو: پنل → سرویس (نوع اکانت) → کشورها
 * شما فقط باید این توابع را در بات خود (روی message/callback) صدا بزنید.
 */
function list_panels(PDO $pdo): array {
  $stmt = $pdo->query("SELECT id, name, profit_percent FROM panels WHERE enabled=1 ORDER BY id");
  return $stmt->fetchAll();
}

function list_services(PDO $pdo, int $panel_id): array {
  $stmt = $pdo->prepare("SELECT id, code, name, base_price_toman FROM services WHERE panel_id=:p ORDER BY id");
  $stmt->execute([':p'=>$panel_id]);
  return $stmt->fetchAll();
}

function build_countries_keyboard(PDO $pdo, array $panel, array $service): array {
  require_once __DIR__.'/../lib/inventory.php';
  $profit = (float)$panel['profit_percent'];
  $countries = inv_get_countries($pdo, (int)$service['id']);
  $keyboard = [];
  foreach ($countries as $c) {
    $price = compute_price_toman((int)$service['base_price_toman'], $profit);
    $label = inv_status_emoji((int)$c['stock'])." ".$c['stock']."   ".number_format($price)."   ".$c['country_name'];
    $cb = "buy|p{$panel['id']}|s{$service['id']}|c{$c['country_code']}";
    $keyboard[] = [['text'=>$label, 'callback_data'=>$cb]];
  }
  // footer: refresh/back
  $keyboard[] = [
    ['text'=>"🔄 بازگشت", 'callback_data'=>"back|s{$service['id']}"]
  ];
  return ['inline_keyboard'=>$keyboard];
}
