<?php
require_once __DIR__.'/../lib/bootstrap.php';
require_once __DIR__.'/../lib/telegram.php';
require_once __DIR__.'/../handlers/buy.php';

/**
 * نمونه استفاده:
 * 1) یک panel انتخاب شده (id=1)، یک service (id=1)
 * 2) ساخت کیبورد کشورها/قیمت‌ها
 */
$panel_id = 1;
$service_id = 1;
$stmt = $pdo->prepare("SELECT * FROM panels WHERE id=:id"); $stmt->execute([':id'=>$panel_id]);
$panel = $stmt->fetch();

$stmt = $pdo->prepare("SELECT * FROM services WHERE id=:id"); $stmt->execute([':id'=>$service_id]);
$service = $stmt->fetch();

$kb = build_countries_keyboard($pdo, $panel, $service);

// صرفاً چاپ JSON برای مشاهده ساختار
header('Content-Type: application/json; charset=utf-8');
echo json_encode($kb, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
