<?php
/**
 * Iran Stars — Telegram Bot (Final Patched)
 * نسخه نهایی با دو مود خرید شماره تلگرام:
 *   ✅ Panel 1 (معمولی)
 *   ✅ Panel 2 (بدون ریپورتی)
 *
 * ویژگی‌ها:
 *  - خرید شماره تلگرام از دو API
 *  - صفحه‌بندی قیمت‌ها
 *  - عدم برداشت وجه تا دریافت کد
 *  - احراز هویت، افزایش و انتقال موجودی
 *  - پنل ادمین (آمار، درصد سود، پیام همگانی)
 *
 * نیازمند:
 *  - class.php (توکن‌ها و اتصال DB)
 *  - jdf.php (تاریخ شمسی)
 *  - sod.txt (درصد سود)
 */

ob_start();
error_reporting(0);
require_once __DIR__ . '/class.php';
date_default_timezone_set('Asia/Tehran');

// =============================================================
// ثابت‌ها
// =============================================================

// API پایه کالینو (هر دو نسل)
define('CALINOO_WEB_BASE', 'https://api.ozvinoo.xyz/web'); 
define('CALINOO_V2_BASE',  'https://api.ozvinoo.xyz');

// توکن Bearer برای نسل دوم (در class.php تعریف شده)
$calinooBearerToken = $apicalino;

// اندازه صفحه (تعداد کشور در هر صفحه)
define('PAGE_SIZE', 10);

// مسیر کش سبک
define('CACHE_DIR', __DIR__ . '/.cache');
if (!is_dir(CACHE_DIR)) { @mkdir(CACHE_DIR, 0775, true); }

// =============================================================
// توابع کمکی کش
// =============================================================
function cache_set($key, $value, $ttl = 30) {
    $path = CACHE_DIR . '/' . md5($key) . '.json';
    $data = ['exp' => time() + $ttl, 'val' => $value];
    @file_put_contents($path, json_encode($data, JSON_UNESCAPED_UNICODE));
}
function cache_get($key) {
    $path = CACHE_DIR . '/' . md5($key) . '.json';
    if (!file_exists($path)) return null;
    $raw = @file_get_contents($path);
    if (!$raw) return null;
    $data = json_decode($raw, true);
    if (!$data || !isset($data['exp'])) return null;
    if (time() > intval($data['exp'])) return null;
    return $data['val'];
}

// =============================================================
// توابع HTTP
// =============================================================
function http_get_json($url, $headers = []) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTPHEADER => array_merge([
            'Accept: application/json',
            'User-Agent: IranStarsBot/1.0'
        ], $headers),
    ]);
    $res = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($err) return [null, $err];
    return [json_decode($res, true), null];
}

function http_post_json($url, $body = null, $headers = []) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => array_merge([
            'Content-Type: application/json',
            'Accept: application/json',
            'User-Agent: IranStarsBot/1.0'
        ], $headers),
        CURLOPT_POSTFIELDS => $body ? json_encode($body, JSON_UNESCAPED_UNICODE) : '{}',
    ]);
    $res = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($err) return [null, $err];
    return [json_decode($res, true), null];
}

// =============================================================
// رابط کاربری (منوها)
// =============================================================

$start = json_encode(["keyboard"=>[
    [['text'=>"♻️ استعلام شماره ها"],['text'=>"🛍 خرید شماره مجازی"]],
    [['text'=>"👤 حساب کاربری"],['text'=>"➕ افزایش موجودی"]],
    [['text'=>"☎️ پشتیبانی"],['text'=>"❓راهنما"],['text'=>"💸 انتقال موجودی"]],
],'resize_keyboard'=>true]);

$back = json_encode(['keyboard'=>[
    [['text'=>"🔙 منو اصلی"]],
],'resize_keyboard'=>true]);

$backp = json_encode(['keyboard'=>[
    [['text'=>"بازگشت"]],
],'resize_keyboard'=>true]);

$panel = json_encode(['keyboard'=>[
    [['text'=>"آمار"],['text'=>"پیام همگانی"]],
    [['text'=>"تعیین درصد سود"]],
    [['text'=>"کاهش موجودی"],['text'=>"افزایش موجودی"]],
    [['text'=>"🔙 منو اصلی"]],
],'resize_keyboard'=>true]);

$join = json_encode(['inline_keyboard'=>[
    [['text'=>'📪 عضویت در کانال','url'=>"$channelink"]],
    [['text'=>'✅ عضو شدم','callback_data'=>'joined']],
]]);

// =============================================================
// دریافت داده از تلگرام
// =============================================================
$update  = json_decode(file_get_contents('php://input'));
$update2 = json_decode(file_get_contents('php://input'), true);

$message        = $update->message;
$callback_query = $update->callback_query;

$from_id    = $message->from->id ?? null;
$chat_id    = $message->chat->id ?? null;
$message_id = $message->message_id ?? null;
$text       = $message->text ?? null;
$caption    = $message->caption ?? null;
$username   = $message->from->username ?? null;

$chatid     = $callback_query->message->chat->id ?? null;
$messageid  = $callback_query->message->message_id ?? null;
$data       = $callback_query->data ?? null;
$membercall = $callback_query->id ?? null;

$photoid = null;
if (isset($update2['message']['photo'])) {
    $photoid = $update2['message']['photo'][count($update2['message']['photo']) - 1]['file_id'];
}

// =============================================================
// داده‌های کاربر از دیتابیس
// =============================================================
$user  = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '{$from_id}' LIMIT 1"));
$user2 = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id = '{$chatid}' LIMIT 1"));

// =============================================================
// توابع کمکی رابط کاربری (صفحه‌بندی + مرتب‌سازی قیمت)
// =============================================================
function paginate_buttons($prefix, $page, $pages) {
    $row = [];
    if ($page > 1)   $row[] = ['text'=>"◀️ قبلی",'callback_data'=> $prefix.'_p'.($page-1)];
    if ($page < $pages) $row[] = ['text'=>"بعدی ▶️",'callback_data'=> $prefix.'_p'.($page+1)];
    return $row ? [$row] : [];
}

function price_sort_and_append_unavailable($items, $priceKey = 'price', $countKey = 'count') {
    $avai = [];
    $nava = [];
    foreach ($items as $it) {
        $countStr = trim($it[$countKey] ?? '');
        $isAvailable = (strpos($countStr,'✅')!==false) || (strtolower($countStr)=='available') || ($countStr=='موجود');
        if ($isAvailable) $avai[] = $it; else $nava[] = $it;
    }
    usort($avai, function($a,$b) use($priceKey){ return intval($a[$priceKey]) <=> intval($b[$priceKey]); });
    return array_merge($avai, $nava);
}

// =============================================================
// آماده‌سازی برای بخش دوم (سرویس‌ها)
// =============================================================
?>

<?php
// =============================================================
// API لایه — Panel 1 (معمولی) و Panel 2 (بدون ریپورتی)
// =============================================================

// ---- Panel 1 (WEB token) ----
function calinoo_panel1_prices($token, $service_id = 1) {
    $cacheKey = "p1_prices_$service_id";
    if ($hit = cache_get($cacheKey)) return $hit;

    $url = CALINOO_WEB_BASE . "/{$token}/get-prices/{$service_id}?format=json";
    list($json, $err) = http_get_json($url);
    if ($err || !is_array($json)) return [];

    cache_set($cacheKey, $json, 30);
    return $json; // [{country, price, range, count}, ...]
}

function calinoo_panel1_get_number($token, $service_id, $range) {
    $url = CALINOO_WEB_BASE . "/{$token}/getNumber/{$service_id}/{$range}?format=json";
    return http_get_json($url); // [json,err]
}
function calinoo_panel1_get_code($token, $request_id) {
    $url = CALINOO_WEB_BASE . "/{$token}/getCode/{$request_id}?format=json";
    return http_get_json($url);
}
function calinoo_panel1_logout($token, $request_id) {
    $url = CALINOO_WEB_BASE . "/{$token}/logout/{$request_id}?format=json";
    return http_get_json($url);
}

// ---- Panel 2 (Bearer token) ----
function calinoo_panel2_numbers($bearer, $none_report = true) {
    $cacheKey = "p2_numbers_" . ($none_report ? 'nr1' : 'nr0');
    if ($hit = cache_get($cacheKey)) return $hit;

    $url = CALINOO_V2_BASE . "/telegram-numbers/numbers/";
    $headers = ["Authorization: Bearer {$bearer}"];
    list($json, $err) = http_get_json($url, $headers);

    if ((!$json || (isset($json['status']) && $json['status']===false)) && !$err) {
        // بعضی سرورها GET body را نادیده می‌گیرند → تلاش با POST
        list($json2, $err2) = http_post_json($url, ['none_report'=>$none_report?true:false], $headers);
        if ($json2 && !$err2) $json = $json2;
    }
    if ($err || !is_array($json)) return [];

    $data = isset($json['data']) && is_array($json['data']) ? $json['data'] : $json;
    cache_set($cacheKey, $data, 20);
    return $data; // [{country, price, range, count, emoji, id?}, ...]
}

function calinoo_panel2_order($bearer, $country_id, $none_report = true) {
    $url = CALINOO_V2_BASE . "/telegram-numbers/number-services/";
    $headers = ["Authorization: Bearer {$bearer}"];
    $body = ['country_id'=>$country_id, 'none_report'=>$none_report?true:false];
    return http_post_json($url, $body, $headers); // [json,err]
}

function calinoo_panel2_getcode($bearer, $order_id) {
    $url = CALINOO_V2_BASE . "/telegram-numbers/number-services/";
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => [
            'Accept: application/json',
            'Content-Type: application/json',
            "Authorization: Bearer {$bearer}",
        ],
        CURLOPT_POSTFIELDS => json_encode(['order_id'=>$order_id]),
        CURLOPT_TIMEOUT => 30
    ]);
    $res = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($err) return [null,$err];
    return [json_decode($res,true), null];
}

function calinoo_panel2_logout($bearer, $order_id) {
    $url = CALINOO_V2_BASE . "/telegram-numbers/number-services/";
    $headers = ["Authorization: Bearer {$bearer}"];
    return http_post_json($url, ['order_id'=>$order_id], $headers);
}

// =============================================================
// منوی تلگرام + یوتیلیتی‌های UI
// =============================================================
function telegram_service_menu_inline() {
    return json_encode(['inline_keyboard'=>[
        [['text'=>'📋 لیست (Panel 1 - معمولی)', 'callback_data'=>'tglist_p1_p1']],
        [['text'=>'📋 لیست (Panel 2 - بدون ریپورتی)', 'callback_data'=>'tglist_p2nr_p1']],
        [['text'=>'🔙 بازگشت','callback_data'=>'main_menu']]
    ]]);
}
function show_main_menu($chat_id) {
    sendmessage($chat_id,"  سلام به ربات خوش آمدید ❣️

📌 جهت استفاده از ربات لطفا یکی از موارد زیر را انتخاب کنید
",$GLOBALS['start']);
}

// =============================================================
// لیست قیمت‌ها (صفحه‌بندی) — Panel 1
// =============================================================
function handle_tglist_panel1($chatid, $messageid, $page = 1) {
    global $apicalino;

    $raw = calinoo_panel1_prices($apicalino, 1);
    if (!is_array($raw)) $raw = [];

    // نرمال‌سازی
    $items = [];
    foreach ($raw as $it) {
        $items[] = [
            'country' => $it['country'] ?? '',
            'price'   => intval($it['price'] ?? 0),
            'range'   => strval($it['range'] ?? ''),
            'count'   => $it['count'] ?? '',
        ];
    }
    $items = price_sort_and_append_unavailable($items, 'price', 'count');

    $total  = count($items);
    $pages  = max(1, (int)ceil($total / PAGE_SIZE));
    $page   = max(1, min($page, $pages));
    $offset = ($page - 1) * PAGE_SIZE;
    $slice  = array_slice($items, $offset, PAGE_SIZE);

    $kb = [];
    foreach ($slice as $it) {
        $kb[] = [
            ['text'=>$it['country'],'callback_data'=>'noop'],
            ['text'=>number_format($it['price']).' تومان','callback_data'=>'noop'],
            ['text'=>$it['count'],'callback_data'=>'noop'],
        ];
        $kb[] = [
            ['text'=>"🛒 خرید (Panel1) {$it['country']}",'callback_data'=>"buy_p1_{$it['range']}"]
        ];
    }
    foreach (paginate_buttons("tglist_p1", $page, $pages) as $row) $kb[] = $row;
    $kb[] = [['text'=>'🔙 بازگشت','callback_data'=>'main_menu']];

    bot('editMessageText', [
        'chat_id'=>$chatid,
        'message_id'=>$messageid,
        'text'=>"📋 لیست کشورها (Panel 1 — معمولی)\nصفحه {$page} از {$pages}\n— مرتب از ارزان به گران؛ سپس ناموجودها",
        'reply_markup'=>json_encode(['inline_keyboard'=>$kb])
    ]);
}

// =============================================================
// لیست قیمت‌ها (صفحه‌بندی) — Panel 2 (none_report)
// =============================================================
function handle_tglist_panel2_nr($chatid, $messageid, $page = 1) {
    global $calinooBearerToken;

    $raw = calinoo_panel2_numbers($calinooBearerToken, true);
    if (!is_array($raw)) $raw = [];

    $items = [];
    foreach ($raw as $it) {
        $items[] = [
            'country' => $it['country'] ?? '',
            'price'   => intval($it['price'] ?? 0),
            'range'   => strval($it['range'] ?? ''),
            'count'   => $it['count'] ?? '',
            'emoji'   => $it['emoji'] ?? '',
            'id'      => $it['id'] ?? ''
        ];
    }
    $items = price_sort_and_append_unavailable($items, 'price', 'count');

    $total  = count($items);
    $pages  = max(1, (int)ceil($total / PAGE_SIZE));
    $page   = max(1, min($page, $pages));
    $offset = ($page - 1) * PAGE_SIZE;
    $slice  = array_slice($items, $offset, PAGE_SIZE);

    $kb = [];
    foreach ($slice as $it) {
        $country = $it['country'];
        $emoji   = $it['emoji'] ? (' '.$it['emoji']) : '';
        $kb[] = [
            ['text'=>"$country$emoji",'callback_data'=>'noop'],
            ['text'=>number_format($it['price']).' تومان','callback_data'=>'noop'],
            ['text'=>$it['count'],'callback_data'=>'noop'],
        ];
        if ($it['id'] !== '') {
            $kb[] = [['text'=>"🛒 خرید (بدون ریپورتی) $country", 'callback_data'=>"buy_p2nr_id_{$it['id']}"]];
        } elseif ($it['range'] !== '') {
            $kb[] = [['text'=>"🛒 خرید (بدون ریپورتی/جایگزین) $country", 'callback_data'=>"buy_p2nr_rg_{$it['range']}"]];
        }
    }
    foreach (paginate_buttons("tglist_p2nr", $page, $pages) as $row) $kb[] = $row;
    $kb[] = [['text'=>'🔙 بازگشت','callback_data'=>'main_menu']];

    bot('editMessageText', [
        'chat_id'=>$chatid,
        'message_id'=>$messageid,
        'text'=>"📋 لیست کشورها (Panel 2 — بدون ریپورتی)\nصفحه {$page} از {$pages}\n— مرتب از ارزان به گران؛ سپس ناموجودها",
        'reply_markup'=>json_encode(['inline_keyboard'=>$kb])
    ]);
}

// =============================================================
// خرید — Panel 1 (بر اساس range)
// =============================================================
function handle_buy_panel1($chatid, $range) {
    global $connect, $user2, $apicalino;

    $prices = calinoo_panel1_prices($apicalino, 1);
    $matched = null;
    foreach ($prices as $it) {
        if (strval($it['range'] ?? '') === strval($range)) { $matched = $it; break; }
    }
    if (!$matched) {
        bot('answerCallbackQuery', ['callback_query_id'=>$_POST['callback_query_id']??'', 'text'=>'کشور یافت نشد!', 'show_alert'=>true]);
        return;
    }

    $countryName = $matched['country'] ?? 'کشور';
    $basePrice   = intval($matched['price'] ?? 0);
    $finalPrice  = $basePrice * (1 + floatval(trim(@file_get_contents('sod.txt'))) / 100.0);

    if ($user2['coin'] < $finalPrice) {
        bot('answerCallbackQuery', ['callback_query_id'=>$_POST['callback_query_id']??'', 'text'=>'❌ موجودی کافی نیست!', 'show_alert'=>true]);
        return;
    }

    list($json, $err) = calinoo_panel1_get_number($apicalino, 1, $range);
    if ($err || !isset($json['number'])) {
        $why = $json['error_msg'] ?? 'نامشخص';
        sendMessage($chatid, "⛔️ خطا در دریافت شماره (Panel 1): {$why}");
        return;
    }

    $number     = $json['number'];
    $request_id = $json['request_id'] ?? '';
    $quality    = $json['quality'] ?? '—';

    $finalPrice = intval($json['price'] ?? $finalPrice);
    $finalPrice = $finalPrice * (1 + floatval(trim(@file_get_contents('sod.txt'))) / 100.0);

    $order_code = uniqid('ORD_', true);
    mysqli_query($connect, "INSERT INTO orders (order_code, chat_id, service, country, phone_number, price, request_id)
        VALUES ('{$order_code}', '{$chatid}', 'telegram', '{$countryName}', '{$number}', '{$finalPrice}', '{$request_id}')");

    $pricenum = number_format($finalPrice);
    $msg = "✅ شماره مجازی دریافت شد (Panel 1)\n\n".
           "📞 شماره: {$number}\n".
           "🌍 کشور: {$countryName}\n".
           "💰 قیمت: {$pricenum} تومان\n".
           "ℹ️ کیفیت: {$quality}\n\n".
           "❗️ تا زمان دریافت کد، مبلغی از حساب شما کسر نخواهد شد!";

    $ik = json_encode(['inline_keyboard'=>[
        [['text'=>'♻️ دریافت کد','callback_data'=>"p1_code_{$order_code}"]],
        [['text'=>'🚪 خروج از اکانت','callback_data'=>"p1_logout_{$request_id}|{$order_code}"]],
        [['text'=>'🔙 منو اصلی','callback_data'=>'main_menu']],
    ]]);
    sendMessage($chatid, $msg, $ik);
}

// =============================================================
// خرید — Panel 2 (بر اساس country_id)
// =============================================================
function handle_buy_panel2_by_id($chatid, $country_id) {
    global $connect, $user2, $calinooBearerToken;

    $items = calinoo_panel2_numbers($calinooBearerToken, true);
    $matched = null;
    foreach ($items as $it) {
        if (strval($it['id'] ?? '') === strval($country_id)) { $matched = $it; break; }
    }
    $countryName = $matched['country'] ?? 'کشور';
    $basePrice   = intval($matched['price'] ?? 0);
    $finalPrice  = $basePrice * (1 + floatval(trim(@file_get_contents('sod.txt'))) / 100.0);

    if ($finalPrice > 0 && $user2['coin'] < $finalPrice) {
        bot('answerCallbackQuery', ['callback_query_id'=>$_POST['callback_query_id']??'', 'text'=>'❌ موجودی کافی نیست!', 'show_alert'=>true]);
        return;
    }

    list($json, $err) = calinoo_panel2_order($calinooBearerToken, $country_id, true);
    if ($err || !$json || ($json['status'] ?? false) === false) {
        $why = $json['message'] ?? 'نامشخص';
        sendMessage($chatid, "⛔️ خطا در دریافت شماره (Panel 2): {$why}");
        return;
    }

    $data     = $json['data'] ?? [];
    $number   = $data['number'] ?? '';
    $order_id = $data['order_id'] ?? '';
    $price    = intval($data['price'] ?? $finalPrice);
    $price    = $price * (1 + floatval(trim(@file_get_contents('sod.txt'))) / 100.0);
    $range    = $data['range'] ?? ($matched['range'] ?? '');
    $quality  = $data['quality'] ?? 'سالم بدون ریپورت';
    $countryHuman = $data['countery'] ?? $countryName;

    $order_code = uniqid('ORD_', true);
    mysqli_query($connect, "INSERT INTO orders (order_code, chat_id, service, country, phone_number, price, request_id)
        VALUES ('{$order_code}', '{$chatid}', 'telegram', '{$countryHuman}', '{$number}', '{$price}', '{$order_id}')");

    $pricenum = number_format($price);
    $msg = "✅ شماره مجازی دریافت شد (Panel 2 - بدون ریپورتی)\n\n".
           "📞 شماره: {$number}\n".
           "🌍 کشور: {$countryHuman}\n".
           "📶 رنج: {$range}\n".
           "💰 قیمت: {$pricenum} تومان\n".
           "🛡 کیفیت: {$quality}\n\n".
           "❗️ تا زمان دریافت کد، مبلغی از حساب شما کسر نخواهد شد!";

    $ik = json_encode(['inline_keyboard'=>[
        [['text'=>'♻️ دریافت کد','callback_data'=>"p2_code_{$order_code}"]],
        [['text'=>'🚪 خروج از اکانت','callback_data'=>"p2_logout_{$order_id}|{$order_code}"]],
        [['text'=>'🔙 منو اصلی','callback_data'=>'main_menu']],
    ]]);
    sendMessage($chatid, $msg, $ik);
}

// =============================================================
// خرید — Panel 2 (Fallback با range → Panel1)
// =============================================================
function handle_buy_panel2_by_range_fallback($chatid, $range) {
    global $connect, $user2, $apicalino;

    $prices = calinoo_panel1_prices($apicalino, 1);
    $matched = null;
    foreach ($prices as $it) {
        if (strval($it['range'] ?? '') === strval($range)) { $matched = $it; break; }
    }
    if (!$matched) { sendMessage($chatid, "⛔️ کشور یافت نشد (fallback)."); return; }

    $countryName = $matched['country'] ?? 'کشور';
    $basePrice   = intval($matched['price'] ?? 0);
    $finalPrice  = $basePrice * (1 + floatval(trim(@file_get_contents('sod.txt'))) / 100.0);

    if ($user2['coin'] < $finalPrice) {
        bot('answerCallbackQuery', ['callback_query_id'=>$_POST['callback_query_id']??'', 'text'=>'❌ موجودی کافی نیست!', 'show_alert'=>true]);
        return;
    }

    list($json, $err) = calinoo_panel1_get_number($apicalino, 1, $range);
    if ($err || !isset($json['number'])) {
        $why = $json['error_msg'] ?? 'نامشخص';
        sendMessage($chatid, "⛔️ خطا در دریافت شماره (fallback): {$why}");
        return;
    }

    $number     = $json['number'];
    $request_id = $json['request_id'] ?? '';
    $quality    = $json['quality'] ?? '—';

    $finalPrice = intval($json['price'] ?? $finalPrice);
    $finalPrice = $finalPrice * (1 + floatval(trim(@file_get_contents('sod.txt'))) / 100.0);

    $order_code = uniqid('ORD_', true);
    mysqli_query($connect, "INSERT INTO orders (order_code, chat_id, service, country, phone_number, price, request_id)
        VALUES ('{$order_code}', '{$chatid}', 'telegram', '{$countryName}', '{$number}', '{$finalPrice}', '{$request_id}')");

    $pricenum = number_format($finalPrice);
    $msg = "✅ شماره مجازی دریافت شد (Panel 2 — جایگزین Panel 1)\n\n".
           "📞 شماره: {$number}\n".
           "🌍 کشور: {$countryName}\n".
           "💰 قیمت: {$pricenum} تومان\n".
           "ℹ️ کیفیت: {$quality}\n\n".
           "❗️ تا زمان دریافت کد، مبلغی از حساب شما کسر نخواهد شد!";

    $ik = json_encode(['inline_keyboard'=>[
        [['text'=>'♻️ دریافت کد','callback_data'=>"p1_code_{$order_code}"]],
        [['text'=>'🚪 خروج از اکانت','callback_data'=>"p1_logout_{$request_id}|{$order_code}"]],
        [['text'=>'🔙 منو اصلی','callback_data'=>'main_menu']],
    ]]);
    sendMessage($chatid, $msg, $ik);
}

// =============================================================
// دریافت کد — Panel 1
// =============================================================
function handle_p1_get_code($chatid, $messageid, $order_code) {
    global $connect, $apicalino, $membercall;

    $order = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM orders WHERE order_code='{$order_code}' LIMIT 1"));
    if (!$order) {
        bot('answerCallbackQuery', ['callback_query_id'=>$membercall, 'text'=>'⛔️ سفارش یافت نشد!', 'show_alert'=>true]);
        return;
    }

    $request_id = $order['request_id'];
    $price      = floatval($order['price']);
    $pricenum   = number_format($price);

    list($resp, $err) = calinoo_panel1_get_code($apicalino, $request_id);
    if ($err || !$resp) {
        bot('answerCallbackQuery', ['callback_query_id'=>$membercall, 'text'=>'خطا در ارتباط با سرویس!', 'show_alert'=>true]);
        return;
    }

    if (isset($resp['code']) && $resp['code']!=='') {
        $code   = $resp['code'];
        $number = $resp['number'] ?? $order['phone_number'];

        if ($order['status']!='complete') {
            mysqli_query($connect, "UPDATE user SET coin=coin-{$price} WHERE id='{$order['chat_id']}'");
            mysqli_query($connect, "UPDATE orders SET status='complete' WHERE order_code='{$order_code}'");
        }

        $msg = "شماره شما: {$number}\nکشور: {$order['country']}\nکد تأیید: {$code}\nقیمت: {$pricenum} تومان\n\n❗️ کد تأیید دریافت شد!";
        $ik  = json_encode(['inline_keyboard'=>[
            [['text'=>'♻️ دریافت مجدد کد','callback_data'=>"p1_code_{$order_code}"]],
            [['text'=>'🛒 خرید مجدد (Panel 1)','callback_data'=>"tglist_p1_p1"]],
            [['text'=>'🚪 خروج از اکانت','callback_data'=>"p1_logout_{$request_id}|{$order_code}"]],
        ]]);

        bot('editMessageText', ['chat_id'=>$chatid, 'message_id'=>$messageid, 'text'=>$msg, 'reply_markup'=>$ik]);
        bot('answerCallbackQuery', ['callback_query_id'=>$membercall,'text'=>'✅ کد تأیید دریافت شد!','show_alert'=>true]);
    } else {
        $err_code = $resp['error_code'] ?? '';
        if ($err_code === 'wait_code') {
            bot('answerCallbackQuery', ['callback_query_id'=>$membercall,'text'=>'⏳ هنوز کدی دریافت نشده. لطفاً بعداً تلاش کنید.','show_alert'=>true]);
        } else {
            $why = $resp['error_msg'] ?? 'نامشخص';
            bot('answerCallbackQuery', ['callback_query_id'=>$membercall,'text'=>"خطا: {$why}",'show_alert'=>true]);
        }
    }
}

// =============================================================
// دریافت کد — Panel 2
// =============================================================
function handle_p2_get_code($chatid, $messageid, $order_code) {
    global $connect, $calinooBearerToken, $membercall;

    $order = mysqli_fetch_assoc(mysqli_query($connect, "SELECT * FROM orders WHERE order_code='{$order_code}' LIMIT 1"));
    if (!$order) {
        bot('answerCallbackQuery', ['callback_query_id'=>$membercall, 'text'=>'⛔️ سفارش یافت نشد!', 'show_alert'=>true]);
        return;
    }

    $order_id = $order['request_id'];
    $price    = floatval($order['price']);
    $pricenum = number_format($price);

    list($resp, $err) = calinoo_panel2_getcode($calinooBearerToken, $order_id);
    if ($err || !$resp) {
        bot('answerCallbackQuery', ['callback_query_id'=>$membercall, 'text'=>'خطا در ارتباط با سرویس!', 'show_alert'=>true]);
        return;
    }

    if (($resp['status'] ?? false) && isset($resp['data']['code'])) {
        $code   = $resp['data']['code'];
        $number = $resp['data']['number'] ?? $order['phone_number'];

        if ($order['status']!='complete') {
            mysqli_query($connect, "UPDATE user SET coin=coin-{$price} WHERE id='{$order['chat_id']}'");
            mysqli_query($connect, "UPDATE orders SET status='complete' WHERE order_code='{$order_code}'");
        }

        $msg = "شماره شما: {$number}\nکشور: {$order['country']}\nکد تأیید: {$code}\nقیمت: {$pricenum} تومان\n\n✅ کد تأیید دریافت شد!";
        $ik  = json_encode(['inline_keyboard'=>[
            [['text'=>'♻️ دریافت مجدد کد','callback_data'=>"p2_code_{$order_code}"]],
            [['text'=>'🛒 خرید مجدد (Panel 2)','callback_data'=>"tglist_p2nr_p1"]],
            [['text'=>'🚪 خروج از اکانت','callback_data'=>"p2_logout_{$order_id}|{$order_code}"]],
        ]]);

        bot('editMessageText', ['chat_id'=>$chatid,'message_id'=>$messageid,'text'=>$msg,'reply_markup'=>$ik]);
        bot('answerCallbackQuery', ['callback_query_id'=>$membercall,'text'=>'✅ کد تأیید دریافت شد!','show_alert'=>true]);
    } else {
        $status_code = intval($resp['status_code'] ?? 0);
        if ($status_code === 202) {
            bot('answerCallbackQuery', ['callback_query_id'=>$membercall,'text'=>'⏳ هنوز کدی دریافت نشده. لطفاً بعداً تلاش کنید.','show_alert'=>true]);
        } else {
            $why = $resp['message'] ?? 'نامشخص';
            bot('answerCallbackQuery', ['callback_query_id'=>$membercall,'text'=>"خطا: {$why}",'show_alert'=>true]);
        }
    }
}

// =============================================================
// خروج — Panel 1 و Panel 2
// =============================================================
function handle_p1_logout($chatid, $messageid, $request_id, $order_code) {
    global $membercall, $apicalino;

    list($resp, $err) = calinoo_panel1_logout($apicalino, $request_id);
    $ok = (!$err && $resp && (($resp['success'] ?? false) === true));

    $ik = json_encode(['inline_keyboard'=>[
        [['text'=>'🛒 خرید مجدد (Panel 1)','callback_data'=>'tglist_p1_p1']],
        [['text'=>'🔙 منو اصلی','callback_data'=>'main_menu']],
    ]]);

    if ($ok) {
        bot('editMessageText', ['chat_id'=>$chatid,'message_id'=>$messageid,'text'=>"✅ خروج از اکانت با موفقیت انجام شد.",'reply_markup'=>$ik]);
        bot('answerCallbackQuery', ['callback_query_id'=>$membercall,'text'=>'✅ خروج با موفقیت انجام شد!','show_alert'=>true]);
    } else {
        $why = $resp['error_msg'] ?? 'نامشخص';
        bot('answerCallbackQuery', ['callback_query_id'=>$membercall,'text'=>"خطا در خروج: {$why}",'show_alert'=>true]);
    }
}

function handle_p2_logout($chatid, $messageid, $order_id, $order_code) {
    global $membercall, $calinooBearerToken;

    list($resp, $err) = calinoo_panel2_logout($calinooBearerToken, $order_id);
    $ok = (!$err && $resp && (($resp['status'] ?? false) === true));

    $ik = json_encode(['inline_keyboard'=>[
        [['text'=>'🛒 خرید مجدد (Panel 2)','callback_data'=>'tglist_p2nr_p1']],
        [['text'=>'🔙 منو اصلی','callback_data'=>'main_menu']],
    ]]);

    if ($ok) {
        bot('editMessageText', ['chat_id'=>$chatid,'message_id'=>$messageid,'text'=>"✅ خروج از اکانت با موفقیت انجام شد.",'reply_markup'=>$ik]);
        bot('answerCallbackQuery', ['callback_query_id'=>$membercall,'text'=>'✅ خروج با موفقیت انجام شد!','show_alert'=>true]);
    } else {
        $why = $resp['message'] ?? 'نامشخص';
        bot('answerCallbackQuery', ['callback_query_id'=>$membercall,'text'=>"خطا در خروج: {$why}",'show_alert'=>true]);
    }
}
?>

<?php
// =============================================================
// Dispatcher اصلی
// =============================================================

// ----- Callback Query Dispatcher -----
if ($data) {

    // ✅ تأیید عضویت
    if ($data == 'joined') {
        if (!join1($chatid)) {
            bot('answerCallbackQuery', [
                'callback_query_id'=>$membercall,
                'text'=>"هنوز در کانال عضو نشده‌اید!",
                'show_alert'=>true
            ]);
            exit();
        } else {
            sendmessage($chatid,"✅ عضویت شما تأیید شد! اکنون می‌توانید از امکانات ربات استفاده کنید.",$start);
        }
    }

    // 🔙 منوی اصلی
    elseif ($data == 'main_menu') {
        show_main_menu($chatid);
    }

    // =============================================================
    // 📋 استعلام شماره‌ها (نمایش منوی سرویس‌ها)
    // =============================================================
    elseif ($data == 'checknumber_telegram' || $data == 'checknumber') {
        sendMessage($chatid, "لطفاً نوع سرویس را انتخاب کنید:", telegram_service_menu_inline());
    }

    // =============================================================
    // 📋 لیست کشورها (Panel 1 و 2)
    // =============================================================
    elseif (preg_match('/^tglist_p1_p(\d+)/',$data,$m)) {
        handle_tglist_panel1($chatid,$messageid,intval($m[1]));
    }
    elseif (preg_match('/^tglist_p2nr_p(\d+)/',$data,$m)) {
        handle_tglist_panel2_nr($chatid,$messageid,intval($m[1]));
    }

    // =============================================================
    // 🛒 خرید شماره‌ها (Panel1/Panel2)
    // =============================================================
    elseif (preg_match('/^buy_p1_(.+)$/',$data,$m)) {
        handle_buy_panel1($chatid,$m[1]);
    }
    elseif (preg_match('/^buy_p2nr_id_(.+)$/',$data,$m)) {
        handle_buy_panel2_by_id($chatid,$m[1]);
    }
    elseif (preg_match('/^buy_p2nr_rg_(.+)$/',$data,$m)) {
        handle_buy_panel2_by_range_fallback($chatid,$m[1]);
    }

    // =============================================================
    // ♻️ دریافت کد (Panel1/Panel2)
    // =============================================================
    elseif (preg_match('/^p1_code_(.+)$/',$data,$m)) {
        handle_p1_get_code($chatid,$messageid,$m[1]);
    }
    elseif (preg_match('/^p2_code_(.+)$/',$data,$m)) {
        handle_p2_get_code($chatid,$messageid,$m[1]);
    }

    // =============================================================
    // 🚪 خروج از اکانت (Panel1/Panel2)
    // =============================================================
    elseif (preg_match('/^p1_logout_(.+)\|(.+)/',$data,$m)) {
        handle_p1_logout($chatid,$messageid,$m[1],$m[2]);
    }
    elseif (preg_match('/^p2_logout_(.+)\|(.+)/',$data,$m)) {
        handle_p2_logout($chatid,$messageid,$m[1],$m[2]);
    }

    // =============================================================
    // 📜 احراز هویت — تایید / رد توسط ادمین
    // =============================================================
    elseif (preg_match('/^(approve|reject)\|(\d+)/',$data,$m)) {
        $action = $m[1]; $uid = $m[2];
        if ($action == 'approve') {
            mysqli_query($connect,"UPDATE user SET verify='yes' WHERE id='$uid'");
            sendMessage($uid,"✅ احراز هویت شما با موفقیت انجام شد!");
        } else {
            mysqli_query($connect,"UPDATE user SET verify='no' WHERE id='$uid'");
            sendMessage($uid,"❌ احراز شما رد شد. با پشتیبانی تماس بگیرید.");
        }
        bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'انجام شد ✅','show_alert'=>true]);
    }

    // =============================================================
    // 📜 احراز هویت درخواست از کاربر
    // =============================================================
    elseif ($data == 'verify_identity') {
        if ($user2['verify'] == 'pending' || $user2['verify'] == 'yes') {
            sendMessage($chatid,"ℹ️ احراز شما قبلاً انجام شده یا در حال بررسی است.");
        } else {
            mysqli_query($connect,"UPDATE user SET step='verify' WHERE id='$chatid'");
            sendMessage($chatid,"📄 لطفاً عکس از کارت بانکی + یادداشت «خرید خدمات مجازی از ایران استارز» را ارسال کنید.\n\nبعد از ارسال منتظر بررسی باشید.",$back);
        }
    }

    // =============================================================
    // 📜 سوابق خرید
    // =============================================================
    elseif ($data == 'purchase_history') {
        include_once 'jdf.php';
        $rows = mysqli_query($connect,"SELECT * FROM orders WHERE chat_id='{$chatid}' AND status='complete' ORDER BY created_at DESC LIMIT 20");
        if (mysqli_num_rows($rows) == 0) {
            bot('answerCallbackQuery',['callback_query_id'=>$membercall,'text'=>'هیچ سفارشی ثبت نشده است.','show_alert'=>true]);
            exit();
        }
        $msg = "🛍 آخرین خریدهای شما:\n\n";
        while ($r = mysqli_fetch_assoc($rows)) {
            $msg .= "📞 {$r['phone_number']}\n🌍 {$r['country']}\n💰 ".number_format($r['price'])." تومان\n📆 ".jdate('Y/m/d',strtotime($r['created_at']))."\n━━━━━━━━━━\n";
        }
        sendMessage($chatid,$msg,$start);
    }
}


// =============================================================
// پیام‌های متنی (Text Dispatcher)
// =============================================================

if ($text) {

    // شروع
    if ($text == '/start' || $text == '🔙 منو اصلی') {
        if (!$user) mysqli_query($connect,"INSERT INTO user (id,step) VALUES ('$chat_id','none')");
        mysqli_query($connect,"UPDATE user SET step='none' WHERE id='$chat_id'");
        if (!join1($chat_id)) {
            sendMessage($chat_id,"⚠️ لطفاً ابتدا در کانال عضو شوید:",$join);
            exit();
        }
        show_main_menu($chat_id);
        exit();
    }

    // اطمینان از عضویت در کانال
    if (!join1($chat_id)) {
        sendMessage($chat_id,"⚠️ کاربر گرامی، ابتدا عضو کانال شوید:",$join);
        exit();
    }

    // 🛍 خرید شماره مجازی
    if ($text == '🛍 خرید شماره مجازی') {
        sendMessage($chat_id, "سرویس مورد نظر را انتخاب کنید:", telegram_service_menu_inline());
        exit();
    }

    // ♻️ استعلام شماره‌ها
    elseif ($text == '♻️ استعلام شماره ها') {
        sendMessage($chat_id,"لطفاً یکی از سرویس‌ها را انتخاب کنید:",telegram_service_menu_inline());
        exit();
    }

    // 📜 ارسال مدرک شناسایی
    elseif ($text == '📜 ارسال مدرک شناسایی') {
        if ($user['verify'] == 'pending' || $user['verify'] == 'yes') {
            sendMessage($chat_id,"احراز شما قبلاً انجام شده یا در حال بررسی است.");
            exit();
        }
        mysqli_query($connect,"UPDATE user SET step='verify' WHERE id='$chat_id'");
        sendMessage($chat_id,"📎 لطفاً تصویر خواسته‌شده را ارسال کنید:",$back);
        exit();
    }

    // مرحله‌ی دریافت مدرک
    elseif ($user['step'] == 'verify' && isset($photoid)) {
        bot('sendPhoto',[
            'chat_id'=>7928656503, // ادمین
            'photo'=>$photoid,
            'caption'=>"🧾 مدرک جدید از کاربر <code>$chat_id</code>\n@$username",
            'parse_mode'=>'HTML',
            'reply_markup'=>json_encode(['inline_keyboard'=>[
                [['text'=>'✅ تایید','callback_data'=>"approve|$chat_id"]],
                [['text'=>'❌ رد','callback_data'=>"reject|$chat_id"]]
            ]])
        ]);
        mysqli_query($connect,"UPDATE user SET verify='pending', step='none' WHERE id='$chat_id'");
        sendMessage($chat_id,"✅ مدرک ارسال شد و در صف بررسی است.",$start);
    }

    // 💸 انتقال موجودی
    elseif ($text == '💸 انتقال موجودی') {
        mysqli_query($connect,"UPDATE user SET step='transfer_id' WHERE id='$chat_id'");
        sendMessage($chat_id,"👤 لطفاً آیدی عددی گیرنده را وارد کنید:",$back);
    }
    elseif ($user['step'] == 'transfer_id' && is_numeric($text)) {
        $target = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM user WHERE id='$text'"));
        if (!$target) { sendMessage($chat_id,"❌ کاربر یافت نشد."); exit(); }
        mysqli_query($connect,"UPDATE user SET step='transfer_amount', temp='$text' WHERE id='$chat_id'");
        sendMessage($chat_id,"💰 مبلغ مورد نظر را به تومان بنویسید:",$back);
    }
    elseif ($user['step'] == 'transfer_amount' && is_numeric($text)) {
        $amount = intval($text);
        $target_id = $user['temp'];
        if ($user['coin'] < $amount) {
            sendMessage($chat_id,"❌ موجودی کافی نیست!\nموجودی فعلی: ".number_format($user['coin'])." تومان",$start);
            mysqli_query($connect,"UPDATE user SET step='none' WHERE id='$chat_id'");
            exit();
        }
        mysqli_query($connect,"UPDATE user SET coin=coin-$amount, step='none', temp='' WHERE id='$chat_id'");
        mysqli_query($connect,"UPDATE user SET coin=coin+$amount WHERE id='$target_id'");
        sendMessage($chat_id,"✅ مبلغ ".number_format($amount)." تومان منتقل شد.",$start);
        sendMessage($target_id,"🎁 مبلغ ".number_format($amount)." تومان از طرف کاربر $chat_id برای شما واریز شد.");
    }

    // ➕ افزایش موجودی
    elseif ($text == '➕ افزایش موجودی') {
        $ik = json_encode(['inline_keyboard'=>[
            [['text'=>'💵 درگاه بانکی','callback_data'=>'zarinpal']]
        ]]);
        sendMessage($chat_id,"روش افزایش موجودی را انتخاب کنید:",$ik);
    }
    elseif ($user['step'] == 'zarinpal' && is_numeric($text)) {
        if ($text < 1000) { sendMessage($chat_id,"حداقل مبلغ هزار تومان است."); exit(); }
        $amo = number_format($text);
        $url = "https://iranstarsz.s14.viptelbot.top/bot/payz.php?amount=$text&chat=$chat_id";
        $ik = json_encode(['inline_keyboard'=>[[['text'=>'💴 پرداخت','url'=>$url]]]]);
        sendMessage($chat_id,"برای پرداخت مبلغ $amo تومان روی دکمه زیر کلیک کنید:",$ik);
        sendMessage($chat_id,"به منوی اصلی برگشتید:",$start);
        mysqli_query($connect,"UPDATE user SET step='none' WHERE id='$chat_id'");
    }

    // 👤 حساب کاربری
    elseif ($text == '👤 حساب کاربری') {
        include_once 'jdf.php';
        $join_date = jdate('Y/m/d', strtotime($user['created_at']));
        $orders = mysqli_fetch_assoc(mysqli_query($connect,"SELECT COUNT(*) as c FROM orders WHERE chat_id='$chat_id' AND status='complete'"));
        $sum = mysqli_fetch_assoc(mysqli_query($connect,"SELECT SUM(price) as t FROM orders WHERE chat_id='$chat_id' AND status='complete'"));
        $coin = number_format($user['coin']);
        $msg = "👤 شناسه: $chat_id\n📆 عضویت: $join_date\n🛒 سفارشات: {$orders['c']}\n💳 مجموع خریدها: ".number_format($sum['t']??0)." تومان\n💰 موجودی: {$coin} تومان";
        $ik = json_encode(['inline_keyboard'=>[
            [['text'=>'📜 سوابق خرید','callback_data'=>'purchase_history']],
            [['text'=>'🔐 احراز هویت','callback_data'=>'verify_identity']]
        ]]);
        sendMessage($chat_id,$msg,$ik);
    }

    // راهنما و پشتیبانی
    elseif ($text == '❓راهنما') {
        sendMessage($chat_id,"📘 راهنما:\n1️⃣ از منوی اصلی گزینه خرید شماره را انتخاب کنید.\n2️⃣ شماره کشور دلخواه را بگیرید.\n3️⃣ بعد از دریافت کد، وجه کسر می‌شود.\n4️⃣ با منوی حساب کاربری می‌توانید سوابق را ببینید.");
    }
    elseif ($text == '☎️ پشتیبانی') {
        sendMessage($chat_id,"☎️ پشتیبانی:\n📩 @IRAN_STARS_SUPPORT\n⏰ زمان پاسخگویی: 10 صبح تا 22 شب");
    }

}
?>

<?php
// =============================================================
// 👑 پنل ادمین (Admin Panel)
// =============================================================
$ADMINS = ['1283220206','7928656503']; // آیدی عددی ادمین‌ها

if (in_array($chat_id, $ADMINS)) {

    // ورود به پنل
    if ($text == '/panel' || $text == '🔙 منو اصلی مدیر') {
        mysqli_query($connect,"UPDATE user SET step='none' WHERE id='$chat_id'");
        sendMessage($chat_id,"👑 پنل مدیریت فعال شد:",$panel);
    }

    // نمایش آمار
    elseif ($text == 'آمار') {
        $users = mysqli_query($connect,"SELECT id FROM user");
        $total = mysqli_num_rows($users);
        $orders = mysqli_query($connect,"SELECT id FROM orders WHERE status='complete'");
        $total_orders = mysqli_num_rows($orders);
        $sum = mysqli_fetch_assoc(mysqli_query($connect,"SELECT SUM(price) as t FROM orders WHERE status='complete'"));
        $income = number_format($sum['t'] ?? 0);
        sendMessage($chat_id,"📊 آمار کلی:\n👥 کاربران: $total\n🛒 سفارشات کامل: $total_orders\n💰 مجموع فروش: $income تومان",$panel);
    }

    // تعیین درصد سود
    elseif ($text == 'تعیین درصد سود') {
        mysqli_query($connect,"UPDATE user SET step='set_profit' WHERE id='$chat_id'");
        sendMessage($chat_id,"📈 درصد سود مورد نظر را وارد کنید (مثلاً 20):",$backp);
    }
    elseif ($user['step'] == 'set_profit' && is_numeric($text)) {
        file_put_contents('sod.txt',$text);
        mysqli_query($connect,"UPDATE user SET step='none' WHERE id='$chat_id'");
        sendMessage($chat_id,"✅ درصد سود با موفقیت تنظیم شد: {$text}%",$panel);
    }

    // پیام همگانی
    elseif ($text == 'پیام همگانی') {
        mysqli_query($connect,"UPDATE user SET step='broadcast' WHERE id='$chat_id'");
        sendMessage($chat_id,"🗣 متن پیام را ارسال کنید:",$backp);
    }
    elseif ($user['step'] == 'broadcast') {
        mysqli_query($connect,"UPDATE user SET step='none' WHERE id='$chat_id'");
        $txt = $text ?: $caption;
        $photo = $photoid ?? null;

        $users = mysqli_query($connect,"SELECT id FROM user");
        $count = 0;
        while ($u = mysqli_fetch_assoc($users)) {
            $uid = $u['id'];
            if ($photo) {
                bot('sendPhoto',['chat_id'=>$uid,'photo'=>$photo,'caption'=>$txt]);
            } else {
                sendMessage($uid,$txt);
            }
            $count++;
            if ($count % 30 == 0) usleep(300000); // تاخیر جلوگیری از Flood
        }
        sendMessage($chat_id,"✅ پیام برای $count کاربر ارسال شد.",$panel);
    }

    // افزایش موجودی کاربر
    elseif ($text == 'افزایش موجودی') {
        mysqli_query($connect,"UPDATE user SET step='add_balance_id' WHERE id='$chat_id'");
        sendMessage($chat_id,"🔢 آیدی عددی کاربر را بفرست:",$backp);
    }
    elseif ($user['step'] == 'add_balance_id' && is_numeric($text)) {
        mysqli_query($connect,"UPDATE user SET step='add_balance_amount', temp='$text' WHERE id='$chat_id'");
        sendMessage($chat_id,"💰 مبلغ مورد نظر (تومان) را وارد کنید:",$backp);
    }
    elseif ($user['step'] == 'add_balance_amount' && is_numeric($text)) {
        $target = $user['temp']; $amount = intval($text);
        mysqli_query($connect,"UPDATE user SET coin=coin+$amount WHERE id='$target'");
        mysqli_query($connect,"UPDATE user SET step='none', temp='' WHERE id='$chat_id'");
        sendMessage($target,"💰 مبلغ ".number_format($amount)." تومان توسط مدیریت به حساب شما اضافه شد ✅");
        sendMessage($chat_id,"انجام شد ✅",$panel);
    }

    // کاهش موجودی
    elseif ($text == 'کاهش موجودی') {
        mysqli_query($connect,"UPDATE user SET step='reduce_balance_id' WHERE id='$chat_id'");
        sendMessage($chat_id,"🔢 آیدی عددی کاربر را بفرست:",$backp);
    }
    elseif ($user['step'] == 'reduce_balance_id' && is_numeric($text)) {
        mysqli_query($connect,"UPDATE user SET step='reduce_balance_amount', temp='$text' WHERE id='$chat_id'");
        sendMessage($chat_id,"📉 مبلغی که می‌خواهید کم کنید (تومان):",$backp);
    }
    elseif ($user['step'] == 'reduce_balance_amount' && is_numeric($text)) {
        $target = $user['temp']; $amount = intval($text);
        mysqli_query($connect,"UPDATE user SET coin=coin-$amount WHERE id='$target'");
        mysqli_query($connect,"UPDATE user SET step='none', temp='' WHERE id='$chat_id'");
        sendMessage($target,"⚠️ مبلغ ".number_format($amount)." تومان از موجودی شما توسط مدیریت کسر شد.");
        sendMessage($chat_id,"کسر موجودی انجام شد ✅",$panel);
    }
}

// =============================================================
// پایان فایل
// =============================================================
?>